/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.dashboardfilters.controllers.impl;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.roninpixels.dashboardhub.app.RequestFactoryWrapper;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.controllers.DashboardFilterRulesController;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.controllers.DashboardFilterRulesFileController;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.web.models.DashboardFilterRule;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DashboardFilterRulesFileControllerImpl
implements DashboardFilterRulesFileController {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardFilterRulesFileControllerImpl.class);
    @Inject
    private RequestFactoryWrapper requestFactory;
    @Inject
    private DashboardFilterRulesController dashboardFilterRulesController;

    @Override
    public String getDashboardFilterRulesAsXml() {
        List<DashboardFilterRule> filterRules = this.dashboardFilterRulesController.getDashboardFilterRules();
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(writer);
        encoder.writeObject(filterRules);
        encoder.close();
        return new String(writer.toString());
    }

    @Override
    public List<DashboardFilterRule> getDashboardFilterRulesFromXml(String xml) {
        List rule = null;
        try (XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(xml.getBytes()));){
            rule = (List)decoder.readObject();
        }
        catch (Exception e) {
            LOG.error("Error reading a filter rule from a xml", (Object)xml);
        }
        return rule;
    }

    @Override
    public InputStream getInputStreamFromUrl(String url) throws ResponseException {
        Request request = this.requestFactory.createRequest(Request.MethodType.GET, url);
        InputStream[] responseInputStream = new InputStream[1];
        request.execute(response -> {
            if (response.getStatusCode() != 200) {
                LOG.error("The following status code was returned when trying to get input stream from URL " + url + " - " + response.getStatusCode());
            }
            responseInputStream[0] = response.getResponseBodyAsStream();
        });
        return responseInputStream[0];
    }

    @Override
    public String getJsonFromUrl(String url) throws ResponseException {
        return this.getJsonFromUrl(url, null, null);
    }

    @Override
    public String getJsonFromUrl(String url, String username, String password) throws ResponseException {
        Request request = this.requestFactory.createRequest(Request.MethodType.GET, url);
        request.setHeader("Accept", "application/json");
        if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
            String token = Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
            request.setHeader("Authorization", "Basic " + token);
        }
        String[] responseString = new String[1];
        request.execute(response -> {
            if (response.getStatusCode() != 200) {
                LOG.error("The following status code was returned when trying to get JSON from URL " + url + " - " + response.getStatusCode());
            }
            responseString[0] = response.getResponseBodyAsString();
        });
        return responseString[0];
    }
}

