/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.utils;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.exceptions.IMessageException;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(ResponseBuilder.class);
    private static DHObjectMapper mapper = new DHObjectMapperImpl();

    public static final Response.ResponseBuilder create(int status) {
        return ResponseBuilder.create(status, null);
    }

    public static final Response.ResponseBuilder create(int status, Object entity) {
        Response.ResponseBuilder rb = Response.status((int)status);
        if (entity != null) {
            if (entity instanceof String) {
                rb.entity(entity);
            } else {
                if (entity instanceof InputStream) {
                    try {
                        rb.entity((Object)mapper.writeInputStreamAsString((InputStream)entity));
                    }
                    catch (IOException e) {
                        log.error("Error on ResponseBuilder creating a response of an input stream", (Throwable)e);
                        return rb.status(500);
                    }
                }
                try {
                    rb.entity((Object)mapper.writeValueAsString(entity));
                }
                catch (IOException e) {
                    log.error("Error on ResponseBuilder creating a response", (Throwable)e);
                    return rb.status(500);
                }
            }
        }
        return rb;
    }

    public static final Response.ResponseBuilder ok(Object entity) {
        return ResponseBuilder.create(200, entity);
    }

    public static final Response createErrorFrom(IMessageException e) {
        return ResponseBuilder.create(e.getCode(), ResponseBuilder.createErrorMessage(e)).build();
    }

    public static final Response createErrorFrom(Exception e, String defaultMessage) {
        if (e instanceof BadRequestToSourceException) {
            return ResponseBuilder.createErrorFrom((BadRequestToSourceException)e);
        }
        log.error(defaultMessage, (Throwable)e);
        return Response.status((int)400).build();
    }

    private static final Map<String, String> createErrorMessage(IMessageException e) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("error", e.getMessage());
        return response;
    }

    public static Response create(Response resp, Map<String, Object> headers) {
        Response.ResponseBuilder builder = ResponseBuilder.create(resp.getStatus(), resp.getEntity());
        if (headers != null && !headers.isEmpty()) {
            headers.keySet().stream().forEach(key -> builder.header(key, headers.get(key)));
        }
        return builder.build();
    }

    public static Response create(Response resp) {
        return ResponseBuilder.create(resp, null);
    }

    public static Response createParseErrorResponse(IOException e) {
        return Response.status((int)400).entity((Object)e.getMessage()).build();
    }

    public static Response createParseErrorResponse(Exception e) {
        if (e.getMessage() != null) {
            if (e.getMessage().contains("CONFLICT")) {
                return Response.status((int)409).entity((Object)"{\"error\": \"CONFLICT\"}").build();
            }
            return Response.status((int)400).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).build();
        }
        return Response.status((int)400).entity((Object)"{\"error\": \"INVALID_INSTANCE\"}").build();
    }
}

