/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.proxy;

import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.net.URL;
import java.net.URLConnection;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyModule {
    private static final Logger log = LoggerFactory.getLogger(ProxyModule.class);
    @Inject
    private Crypto crypto;

    private static final String getExpirationTime() {
        return ZonedDateTime.now().plusYears(1L).format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public Response proxy(@PathParam(value="data") String data) {
        String target = null;
        try {
            target = this.crypto.decryptFrontend(data);
            log.debug("Path requested -> " + target);
        }
        catch (Exception e) {
            log.error("Problems with a request at proxy", (Object)e.getMessage());
            return Response.status((int)400).build();
        }
        try {
            URLConnection connection = new URL(target).openConnection();
            connection.connect();
            return ResponseBuilder.ok(connection.getInputStream()).header("Expires", (Object)ProxyModule.getExpirationTime()).build();
        }
        catch (Exception e) {
            log.error("Problems with a request at proxy", (Throwable)e);
            return Response.status((int)404).header("Expires", (Object)ProxyModule.getExpirationTime()).build();
        }
    }
}

