/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.projectrak.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.ProjectrakConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.web.rest.base.jira.api.GenericJiraEndpoint;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldEndpoint {
    private static final Logger log = LoggerFactory.getLogger(FieldEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    public Response get(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @NotNull @PathParam(value="projectKey") String projectKey, @NotNull @PathParam(value="fieldId") Integer fieldId) {
        String urlTarget = "not defined";
        try {
            ProjectrakConnector projectrak = (ProjectrakConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            urlTarget = projectrak.getURL();
            Map response = projectrak.getField(projectKey, fieldId);
            return ResponseBuilder.ok(response).build();
        }
        catch (BadRequestToSourceException bre) {
            log.error("Problems getting projectrak field from " + urlTarget, (Throwable)bre);
            return GenericJiraEndpoint.generateResponse(bre);
        }
        catch (Exception e) {
            log.error("Problems getting projectrak field from " + urlTarget, (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

