/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.hiddenFeatures;

import com.roninpixels.dashboardhub.config.frontedModel.FrontendCacheSettingsModel;
import com.roninpixels.dashboardhub.controllers.FrontendCacheSettingsController;
import com.roninpixels.dashboardhub.exceptions.NotAuthorizedException;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/hiddenFeatures")
public class FrontendCacheEnablerEndpoint {
    @Inject
    private FrontendCacheSettingsController frontendCacheConfigController;

    @GET
    @Path(value="/frontendCacheEnabler")
    @Produces(value={"application/json"})
    public Response getAddonLicenseInfo(@NotNull @QueryParam(value="enabled") Boolean cacheEnabled) {
        try {
            FrontendCacheSettingsModel newConfig = new FrontendCacheSettingsModel();
            newConfig.setEnabled(cacheEnabled);
            this.frontendCacheConfigController.updateCacheSettings(newConfig);
            return ResponseBuilder.create(200, "ok").build();
        }
        catch (Exception e) {
            int code = e instanceof NotAuthorizedException ? 403 : 400;
            return ResponseBuilder.create(code, e.getMessage()).build();
        }
    }
}

