/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dashboardHub.boards;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.roninpixels.dashboardhub.controllers.AdminBoardsController;
import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.exceptions.BadRequestException;
import com.roninpixels.dashboardhub.gadgetsValidators.GadgetValidatorException;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.ResponseBoardModel;
import com.roninpixels.dashboardhub.web.models.ResponseChangeOwnerModel;
import com.roninpixels.dashboardhub.web.rest.base.MessagesUtil;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.boards.BoardsMessageModel;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.boards.ChangeOwnerMessageModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BoardEndpoint {
    private static final Logger log = LoggerFactory.getLogger(BoardEndpoint.class);
    @Inject
    private BoardsController boardsController;
    @Inject
    private AdminBoardsController adminBoardsController;
    @Inject
    private DHObjectMapper globalMapper;

    public Response getBoards(@DefaultValue(value="true") @QueryParam(value="global") Boolean global, @DefaultValue(value="false") @QueryParam(value="expand") Boolean expand, @DefaultValue(value="false") @QueryParam(value="sharedWithMe") Boolean sharedWithMe) {
        try {
            List boards = sharedWithMe != false ? this.boardsController.getAllSharedWithMeBoards(expand) : this.boardsController.getAllBoards(global, expand);
            HashMap<String, List> data = new HashMap<String, List>();
            data.put("boards", boards);
            return ResponseBuilder.ok(data).build();
        }
        catch (Exception e) {
            log.error(String.format("Problems getting a board -> global: %s, expand: %s", global, expand), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    public Response getAllBoards() {
        try {
            List<ResponseBoardModel> boards = this.adminBoardsController.getFullBoardList();
            HashMap<String, List<ResponseBoardModel>> data = new HashMap<String, List<ResponseBoardModel>>();
            data.put("boards", boards);
            return ResponseBuilder.ok(data).build();
        }
        catch (BadRequestException bre) {
            return Response.status((int)bre.getStatusCode()).entity((Object)bre.getMessage()).build();
        }
        catch (Exception e) {
            log.error(String.format("Problems getting full list boards", new Object[0]), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    public Response changeOwner(ChangeOwnerMessageModel message) {
        try {
            List<String> boardIds = message.getBoardsIds();
            String newOwner = message.getNewOwner();
            ResponseChangeOwnerModel changeOwnerResponse = this.adminBoardsController.changeWallboardsOwner(boardIds, newOwner);
            return ResponseBuilder.ok(changeOwnerResponse).build();
        }
        catch (BadRequestException bre) {
            return Response.status((int)bre.getStatusCode()).entity((Object)bre.getMessage()).build();
        }
        catch (Exception e) {
            log.error("Problems changing boards owner", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    public Response disablePublicLink(@NotNull @PathParam(value="boardId") String boardId) {
        try {
            boolean result = this.adminBoardsController.disablePublicLink(boardId);
            HashMap<String, Boolean> response = new HashMap<String, Boolean>();
            response.put("result", result);
            return ResponseBuilder.ok(response).build();
        }
        catch (BadRequestException bre) {
            return Response.status((int)bre.getStatusCode()).entity((Object)bre.getMessage()).build();
        }
        catch (Exception e) {
            log.error("Problems disabling public link", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    public Response getBoardById(@NotNull @PathParam(value="id") String id, @DefaultValue(value="true") @QueryParam(value="global") Boolean global) {
        try {
            BoardModel board = this.boardsController.getBoard(id, global);
            if (board == null) {
                return Response.status((int)404).build();
            }
            if (!this.boardsController.checkUserLoggedCanView(board)) {
                return MessagesUtil.generateErrorResponse(403, "FORBIDDEN");
            }
            DHObjectMapperImpl mapper = new DHObjectMapperImpl();
            mapper.enable(SerializationFeature.WRAP_ROOT_VALUE);
            return Response.ok((Object)mapper.writeValueAsString(board)).build();
        }
        catch (Exception e) {
            log.error("Problems getting a board with id -> " + id, (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    public Response setBoard(BoardsMessageModel message) {
        try {
            BoardModel board = message.getBoard();
            BoardModel newBoard = this.boardsController.addBoard(board);
            DHObjectMapperImpl mapper = new DHObjectMapperImpl();
            mapper.enable(SerializationFeature.WRAP_ROOT_VALUE);
            return Response.ok((Object)mapper.writeValueAsString(newBoard)).build();
        }
        catch (GadgetValidatorException ge) {
            return MessagesUtil.generateValidationErrorResponse();
        }
        catch (Exception e) {
            log.error("Problems creating a board", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    public Response cloneBoard(@NotNull @PathParam(value="originalBoardId") String originalBoardId, BoardsMessageModel message) {
        try {
            BoardModel board = message.getBoard();
            BoardModel newBoard = this.boardsController.cloneBoard(board, originalBoardId);
            DHObjectMapperImpl mapper = new DHObjectMapperImpl();
            mapper.enable(SerializationFeature.WRAP_ROOT_VALUE);
            return Response.ok((Object)mapper.writeValueAsString(newBoard)).build();
        }
        catch (GadgetValidatorException ge) {
            return MessagesUtil.generateValidationErrorResponse();
        }
        catch (Exception e) {
            log.error("Problems creating a board", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    public Response setBoard(@NotNull @PathParam(value="id") String id, BoardsMessageModel message) {
        try {
            BoardModel board = message.getBoard();
            board.setShared(null);
            BoardModel oldBoard = this.boardsController.getBoard(board.getId());
            if (!this.boardsController.checkUserLoggedCanEdit(oldBoard)) {
                return MessagesUtil.generateErrorResponse(403, "FORBIDDEN");
            }
            BoardModel newBoard = this.boardsController.updateBoard(board);
            DHObjectMapperImpl mapper = new DHObjectMapperImpl();
            mapper.enable(SerializationFeature.WRAP_ROOT_VALUE);
            return Response.ok((Object)mapper.writeValueAsString(newBoard)).build();
        }
        catch (GadgetValidatorException ge) {
            return MessagesUtil.generateValidationErrorResponse();
        }
        catch (Exception e) {
            log.error("Problems creating or updating a board - id -> " + id, (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    public Response deleteBoardById(@NotNull @PathParam(value="id") String id, @DefaultValue(value="true") @QueryParam(value="global") Boolean global) {
        try {
            BoardModel storedBoard = this.boardsController.getBoard(id);
            if (!this.boardsController.checkUserLoggedCanEdit(storedBoard)) {
                return MessagesUtil.generateErrorResponse(403, "FORBIDDEN");
            }
            boolean removed = this.boardsController.removeBoard(id, global);
            HashMap<String, String> msg = new HashMap<String, String>();
            if (removed) {
                msg.put("status", "ok");
            } else {
                msg.put("error", "The board couldn't be deleted");
            }
            return Response.ok((Object)this.globalMapper.writeValueAsString(msg)).build();
        }
        catch (Exception e) {
            log.error("Problems deleting the board - id -> " + id, (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

