/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.customReports;

import com.roninpixels.dashboardhub.gadgetsRequesters.CustomReportsGadgetRequestService;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customReports.CustomReportsGadgetRequestModel;
import com.roninpixels.dashboardhub.services.DHSessionService;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.PublicLinkSessionService;
import com.roninpixels.dashboardhub.services.impl.DHSession;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Response;

public class CRGadgetRequesterEndpoint {
    @Inject
    private CustomReportsGadgetRequestService gadgetsRequestEndpoint;
    @Inject
    private DHObjectMapper mapper;
    @Inject
    private DHSessionService dhSessionService;
    @Inject
    private DHUserService dhUserService;
    @Inject
    private PublicLinkSessionService publicLinkSessionHandlerService;

    public Response doRequest(@HeaderParam(value="Dhsession") String dhSessionToken, @HeaderParam(value="Dhpublicsession") String dhPublicToken, String gadgetRequestRaw) {
        CustomReportsGadgetRequestModel gadgetRequest = null;
        try {
            gadgetRequest = this.mapper.readValue(gadgetRequestRaw, CustomReportsGadgetRequestModel.class);
        }
        catch (IOException e) {
            return ResponseBuilder.createParseErrorResponse(e);
        }
        HashMap<String, Object> sessionHeaders = new HashMap<String, Object>();
        try {
            DHSession dhSession = this.dhSessionService.validateToken(dhSessionToken);
            sessionHeaders.put("dhsession", this.dhSessionService.renovate(dhSession));
            if (dhSession.isExternal()) {
                String newDHPublicSession = this.publicLinkSessionHandlerService.validateToken(gadgetRequest.getBoardToken(), dhPublicToken);
                sessionHeaders.put("dhpublicsession", newDHPublicSession);
            }
        }
        catch (Exception e) {
            return ResponseBuilder.create(401).build();
        }
        Response resp = this.gadgetsRequestEndpoint.doRequest(gadgetRequest);
        return ResponseBuilder.create(resp, sessionHeaders);
    }
}

