/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base;

import com.fasterxml.jackson.core.type.TypeReference;
import com.roninpixels.dashboardhub.controllers.AddonPropertiesController;
import com.roninpixels.dashboardhub.controllers.ResponseMessage;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.PropertyModel;
import com.roninpixels.dashboardhub.web.rest.base.MessagesUtil;
import com.roninpixels.dashboardhub.web.rest.base.OperationMessage;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/properties")
public class PropertiesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(PropertiesEndpoint.class);
    @Inject
    private AddonPropertiesController controller;
    @Inject
    private DHObjectMapper mapper;

    @GET
    @Path(value="/{key}")
    @Produces(value={"application/json"})
    public Response getProperty(@NotNull @PathParam(value="key") String key) {
        try {
            PropertyModel property = this.controller.get(key);
            if (property != null) {
                return ResponseBuilder.ok(property).build();
            }
            OperationMessage op = new OperationMessage("Property not found.", 404);
            return ResponseBuilder.create(404, op).build();
        }
        catch (IOException e) {
            log.error("Problems getting a property -> " + key, (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @PUT
    @Path(value="/{key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setProperty(@NotNull @PathParam(value="key") String key, @Context HttpServletRequest request, InputStream requestBody) {
        try {
            Object value = this.mapper.readValue(requestBody, Object.class);
            Object actualValue = value instanceof Object[] ? this.mapper.convertValue(value, new TypeReference<List<Object>>(){}) : this.mapper.convertValue(value, new TypeReference<Map<String, Object>>(){});
            ResponseMessage res = this.controller.createOrUpdate(key, actualValue);
            OperationMessage op = MessagesUtil.createdOP(res, "Property");
            return ResponseBuilder.create(op.getStatusCode(), op).build();
        }
        catch (Exception e) {
            log.error("Problems updating a property: " + key, (Throwable)e);
            return Response.status((int)404).build();
        }
    }

    @DELETE
    @Path(value="/{key}")
    @Produces(value={"application/json"})
    public Response removeProperty(@NotNull @PathParam(value="key") String key) {
        ResponseMessage res = this.controller.delete(key);
        if (res == ResponseMessage.DELETED) {
            return Response.status((int)204).build();
        }
        OperationMessage op = new OperationMessage("Bad request", 400);
        return ResponseBuilder.ok(op).build();
    }
}

