/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.utils;

import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class TokenGeneratorImpl
implements TokenGenerator {
    @Inject
    private Crypto crypto;
    @Inject
    private DHObjectMapper mMapper;

    @Override
    public String generate(TokenContentModel tokenContent) {
        try {
            String rawToken = this.mMapper.writeValueAsString(tokenContent);
            String encryptedToken = this.crypto.encryptBackend(rawToken);
            return encryptedToken;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems with a token generation", e);
        }
    }

    @Override
    public TokenContentModel getTokenContent(String token) {
        try {
            String json = this.crypto.decryptBackend(token);
            return this.mMapper.readValue(json, TokenContentModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem recovering a token content", e);
        }
    }
}

