/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.fasterxml.jackson.core.type.TypeReference;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.jsonBeans.VersionBean;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.ReleaseConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDateUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.TimePeriodOption;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.TimePeriodUtil;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Releases
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(Releases.class);
    private static final List<String> JQL_DEFAULT_FIELDS = Arrays.asList("status", "id", "fixVersions");
    @Inject
    private DHObjectMapper mapper;

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        ReleaseConfig config = GadgetRequesterUtils.getConfig(gadget, ReleaseConfig.class);
        try {
            List instanceFields = this.getFields();
            List<Map> projectsData = this.getProjects(config);
            List<VersionBean> versions = this.getVersions(config, projectsData);
            if (versions.isEmpty()) {
                return Collections.emptyList();
            }
            return projectsData.parallelStream().map(project -> {
                String projectId = (String)project.get("id");
                String projectName = (String)project.get("name");
                String projectKey = (String)project.get("key");
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("project", projectId);
                data.put("projectName", projectName);
                data.put("projectKey", projectKey);
                data.put("versions", versions.stream().filter(version -> projectId.equals(version.getProjectId().toString())).collect(Collectors.toList()));
                String jql = String.format("project in (%s) AND fixVersion in (%s)", projectId, String.join((CharSequence)",", versions.stream().map(v -> String.format("'%s'", v.getName())).collect(Collectors.toList())));
                LinkedList<String> fields = new LinkedList<String>(JQL_DEFAULT_FIELDS);
                fields.addAll(JiraSprintDataUtils.extractFieldsNamesFromMetric(config.getMetric()));
                List<Map> issues = this.execJQLwithFilterFields(jql, fields, instanceFields, null, null, new HashMap<String, Object>(), null).getIssues();
                data.put("issues", issues);
                return data;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }

    private List<String> getProjectsFromConfig(ReleaseConfig config) {
        LinkedList<String> projects = new LinkedList<String>();
        if (config.getProjects() != null) {
            projects.addAll(config.getProjects());
        } else if (config.getProject() != null) {
            projects.add("" + config.getProject());
        }
        return projects;
    }

    private List<Map> getProjects(ReleaseConfig config) {
        return this.getProjectsFromConfig(config).parallelStream().map(projectId -> (Map)this.jiraConnector.getProject((String)projectId).getBody()).collect(Collectors.toList());
    }

    private List<VersionBean> getVersions(ReleaseConfig config, List<Map> projectsData) {
        List<Object> statusAccepted = config.getStatus() == null ? new LinkedList() : config.getStatus();
        return projectsData.parallelStream().map(projectData -> {
            Collection<VersionBean> data = this.mapper.convertValue(projectData.get("versions"), new TypeReference<Collection<VersionBean>>(){});
            return data.stream().filter(version -> {
                if (config.getByTime().booleanValue() && version.getReleaseDate() != null) {
                    return TimePeriodUtil.matchOptionTimePeriod(TimePeriodOption.getById(config.getTimePeriod()), version.getReleaseDate());
                }
                return true;
            }).filter(version -> statusAccepted.isEmpty() || version.isReleased() != false && statusAccepted.contains("released") || version.isArchived() != false && statusAccepted.contains("archived") || version.isArchived() == false && version.isReleased() == false && statusAccepted.contains("unreleased")).sorted((v1, v2) -> {
                Long v1Time = v1.getReleaseDate() != null ? JiraDateUtils.getMillisFrom(v1.getReleaseDate()) : 0L;
                Long v2Time = v2.getReleaseDate() != null ? JiraDateUtils.getMillisFrom(v2.getReleaseDate()) : 0L;
                return v2Time.compareTo(v1Time);
            }).collect(Collectors.toList());
        }).flatMap(versions -> versions.stream().limit(config.getReleaseAmount().intValue())).collect(Collectors.toList());
    }
}

