/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.fasterxml.jackson.core.type.TypeReference;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.EpicProgressConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Filter;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JqlUtils;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class EpicProgress
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(EpicProgress.class);
    static final String DEFAULT_EPIC_LINK_FIELD_NAME = "Epic Link";
    static final List<String> DEFAULT_EPIC_FIELDS = Arrays.asList("status", "id", "duedate", "summary");
    static final List<String> DEFAULT_ISSUE_FIELDS = Arrays.asList("status", "id");

    protected Field getEpicLinkField() throws Exception {
        ResponseEntity<String> rawResponse = this.jiraConnector.getFields();
        List<Field> fieldList = ResponseChecker.checkStatusAndParse(rawResponse, new TypeReference<List<Field>>(){});
        return fieldList.stream().filter(field -> DEFAULT_EPIC_LINK_FIELD_NAME.equalsIgnoreCase(field.getName())).findFirst().orElse(null);
    }

    protected String getEpicLinkFieldClauseName() {
        try {
            Field epicLinkField = this.getEpicLinkField();
            List clauseNames = (List)epicLinkField.getOtherFields().get("clauseNames");
            return (String)clauseNames.get(0);
        }
        catch (Exception e) {
            log.warn("Something went wrong getting the epic clauseName. Returning the default one.", (Throwable)e);
            return DEFAULT_EPIC_LINK_FIELD_NAME;
        }
    }

    List<Map> getEpics(EpicProgressConfig config, List<String> extraFields, List<Field> instanceFields) {
        List<String> fields = new LinkedList<String>(DEFAULT_EPIC_FIELDS);
        if (extraFields != null) {
            fields.addAll(extraFields);
        }
        fields = fields.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Filter filter = config.getFilter();
        String partialJql = filter.getJql();
        String entityType = config.getEntityType();
        String entityTypeClause = String.format("issuetype = \"%s\"", entityType);
        String jql = JqlUtils.appendToJql(partialJql, entityTypeClause, "AND");
        return this.execJQLwithFilterFields(jql, fields, instanceFields, null, null, null, "").getIssues();
    }

    void populateWithIssues(List<Map> epics, List<String> metric, List<Field> instanceFields) {
        String epicLinkFieldName = this.getEpicLinkFieldClauseName();
        LinkedList<String> fields = new LinkedList<String>(DEFAULT_ISSUE_FIELDS);
        if (metric != null) {
            fields.addAll(JiraSprintDataUtils.extractFieldsNamesFromMetric(metric));
        }
        epics.parallelStream().forEach(epic -> {
            String key = (String)epic.get("key");
            List<Map> issues = this.execJQLwithFilterFields(String.format("\"%s\" = \"%s\" OR parent = \"%s\"", epicLinkFieldName, key, key), fields, instanceFields, null, null, null, null).getIssues();
            epic.put("issues", issues);
        });
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        EpicProgressConfig config = GadgetRequesterUtils.getConfig(gadget, EpicProgressConfig.class);
        try {
            List instanceFields = this.getFields();
            List<Map> epics = this.getEpics(config, extraParams, instanceFields);
            this.populateWithIssues(epics, config.getMetric(), instanceFields);
            HashMap<String, List<Map>> responseObj = new HashMap<String, List<Map>>();
            responseObj.put("epics", epics);
            return responseObj;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }
}

