/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.customReports;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.factories.CustomReportsConnectorFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.CustomReportConnector;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customReports.FetchOptions;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

public class CustomReportsWidget
implements GadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(CustomReportsWidget.class);
    @Inject
    private ConnectorsProvider provider;
    @Inject
    private CustomReportsConnectorFactory connectorFactory;
    private CustomReportConnector mConnector;
    private FetchOptions mFetchOptions;

    @Override
    public void init(DatasourceModel datasource, Map context) {
        this.mFetchOptions = (FetchOptions)context.get("fetchOptions");
        this.mConnector = (CustomReportConnector)this.connectorFactory.createConnector(datasource);
        if (this.mConnector == null) {
            throw new IllegalArgumentException("Datasource is not valid for gadget requester: " + this.getClass().getAnnotation(Component.class));
        }
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        CustomReportConnector.RequestConfig config = new CustomReportConnector.RequestConfig();
        try {
            URI dsURI = new URI(this.mConnector.getURL());
            URI fetchedURI = new URI(this.mFetchOptions.getUri());
            UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.mFetchOptions.getUri());
            builder.replacePath(dsURI.getPath() + fetchedURI.getPath());
            builder.scheme(dsURI.getScheme());
            builder.host(dsURI.getHost());
            config.setUrl(URLDecoder.decode(builder.build().toUriString(), StandardCharsets.UTF_8));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        config.setMethod(Request.MethodType.GET);
        if (this.mFetchOptions.getOptions().getMethod() != null) {
            config.setMethod(Request.MethodType.valueOf((String)this.mFetchOptions.getOptions().getMethod()));
        }
        ResponseEntity response = this.mConnector.executeRequest(config);
        ResponseChecker.checkStatus(response);
        return response.getBody();
    }
}

