/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.bigpicture;

import com.roninpixels.dashboardhub.controllers.bigpicture.models.Box;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxFlattened;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskBoxFieldValues;
import com.roninpixels.dashboardhub.controllers.bigpicture.utils.MappingUtils;
import com.roninpixels.dashboardhub.exceptions.BadRequestException;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.bigpicture.BigPictureBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.bigpicture.utils.BoxFilterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.bigpicture.utils.CommonUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.bigpicture.utils.TasksFilterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customChartsConfig.BQLSearchBoxConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customChartsConfig.BQLSearchConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customChartsConfig.BQLSearchTaskConfig;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BQLSearch
extends BigPictureBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(BQLSearch.class);

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        try {
            BQLSearchConfig config = null;
            String entityName = (String)gadget.getConfig().getOtherConfig().get("entityName");
            config = CommonUtils.isTaskEntityType(entityName) ? (BQLSearchConfig)GadgetRequesterUtils.getConfig(gadget, BQLSearchTaskConfig.class) : (BQLSearchConfig)GadgetRequesterUtils.getConfig(gadget, BQLSearchBoxConfig.class);
            List<BoxFlattened> boxFlatteneds = this.bigPictureController.getBoxesFlattened();
            List<BoxFlattened> filteredBoxFlatteneds = BoxFilterUtils.getFilteredBoxes(boxFlatteneds, config);
            if (filteredBoxFlatteneds.isEmpty()) {
                return new ArrayList();
            }
            List<String> boxIds = filteredBoxFlatteneds.stream().map(Box::getId).collect(Collectors.toList());
            List<String> configFieldIds = config.getColumnsAndFields();
            List<String> configFieldIdsWithoutEntitiesIds = MappingUtils.removeEntityFieldsFromList(configFieldIds);
            if (CommonUtils.isTaskEntityType(entityName)) {
                BQLSearchTaskConfig taskConfig = (BQLSearchTaskConfig)config;
                List<Map> taskFields = this.bigPictureController.getTaskFields();
                List<String> filterTaskNames = taskConfig.getTaskFilterFieldNames();
                List<String> filterTaskIds = CommonUtils.getFieldIdsByName(taskFields, filterTaskNames);
                List<String> taskFieldIds = new LinkedList<String>(configFieldIdsWithoutEntitiesIds);
                taskFieldIds.addAll(filterTaskIds);
                taskFieldIds = taskFieldIds.stream().distinct().collect(Collectors.toList());
                Map taskFilters = taskConfig.getTaskFilters();
                if (taskFieldIds.isEmpty()) {
                    throw new BadRequestException(400, "No task fields found");
                }
                List<TaskBoxFieldValues> allTasks = this.bigPictureController.getTaskFieldsValues(boxIds, taskFieldIds);
                List<TaskBoxFieldValues> allTasksFiltered = TasksFilterUtils.getFilteredTasks(allTasks, taskFilters, taskFields);
                return allTasksFiltered;
            }
            Map<String, Map<String, Map>> rawBoxValueByFieldIdByBoxId = this.bigPictureController.getBoxFieldValues(boxIds, configFieldIdsWithoutEntitiesIds);
            return filteredBoxFlatteneds.stream().map(filteredBox -> {
                Map fields = (Map)rawBoxValueByFieldIdByBoxId.get(filteredBox.getId());
                filteredBox.setFields(fields);
                return filteredBox;
            }).collect(Collectors.toList());
        }
        catch (BadRequestToSourceException btse) {
            throw btse;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

