/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters;

import com.roninpixels.dashboardhub.controllers.BoardPermissionsController;
import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.controllers.DatasourcePermissionsController;
import com.roninpixels.dashboardhub.controllers.gadgets.GadgetModelsFactory;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequesterException;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.GadgetRequestModel;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customReports.CustomReportsGadgetRequestModel;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import java.io.IOException;
import java.util.Collection;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class SecureGadgetDefProviderSrv {
    @Inject
    private BoardsController boardsController;
    @Inject
    private DatasourcesController dsController;
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private BoardPermissionsController boardPermissionsController;
    @Inject
    private DatasourcePermissionsController dsPermissionsController;
    @Inject
    private GadgetModelsFactory gadgetModelsFactory;
    @Inject
    private DHUserService userService;

    public void checkAccess(BoardModel board) throws GadgetRequesterException {
        if (board == null) {
            throw new GadgetRequesterException("Not found", 404);
        }
        String userKey = this.userService.getLoggedInUserKey();
        boolean allowedBoard = this.boardPermissionsController.isBoardVisibleFor(board, userKey);
        if (!allowedBoard) {
            throw new GadgetRequesterException("Forbidden", 403);
        }
    }

    private GadgetModel getGadgetFromBoard(GadgetRequestModel gadgetRequest, TokenContentModel token) throws GadgetRequesterException {
        BoardModel storedBoard = this.boardsController.getBoard(token.getBoardId());
        this.checkAccess(storedBoard);
        String requestedGadgetId = gadgetRequest.getGadgetId() != null ? gadgetRequest.getGadgetId() : gadgetRequest.getGadget().getId();
        GadgetModel storedGadget = storedBoard.getData().stream().flatMap(Collection::stream).filter(gadget -> requestedGadgetId.equals(gadget.getId())).findAny().orElse(null);
        if (storedGadget != null) {
            this.retrieveAndPopulateDS(storedGadget, gadgetRequest);
        }
        return storedGadget;
    }

    public GadgetModel checkAndGetStoredGadget(GadgetRequestModel gadgetRequest) throws GadgetRequesterException {
        TokenContentModel token = this.tokenGenerator.getTokenContent(gadgetRequest.getBoardToken());
        if (token.getBoardId() != null) {
            return this.getGadgetFromBoard(gadgetRequest, token);
        }
        if (token.getContainerId() != null && token.getItemId() != null) {
            return this.gadgetModelsFactory.getGadgetByToken(token);
        }
        throw new GadgetRequesterException("INVALID_GADGET", 400);
    }

    public GadgetModel checkAndGetGadgetByRequest(GadgetRequestModel gadgetRequest) throws GadgetRequesterException {
        GadgetModel requestedGadget = gadgetRequest.getGadget();
        GadgetModel storedGadget = gadgetRequest.getBoardToken() == null ? null : this.checkAndGetStoredGadget(gadgetRequest);
        String requestedDsId = this.getDsId(requestedGadget, gadgetRequest);
        if (requestedDsId == null) {
            throw new GadgetRequesterException("Invalid gadget - null datasource", 400);
        }
        if (storedGadget != null && requestedDsId.equals(this.getDsId(storedGadget, null))) {
            requestedGadget.getConfig().setDatasource(storedGadget.getConfig().getDatasource());
        } else {
            DatasourceModel requestedDS = this.retrieveAndPopulateDS(requestedGadget, gadgetRequest);
            if (!this.dsPermissionsController.isLoggedInUserAllowedToUse(requestedDS)) {
                throw new GadgetRequesterException("Forbidden - invalid gadget", 403);
            }
        }
        return gadgetRequest.getGadget();
    }

    private String getDsId(GadgetModel gadget, GadgetRequestModel gadgetRequest) {
        if (gadgetRequest instanceof CustomReportsGadgetRequestModel) {
            return ((CustomReportsGadgetRequestModel)gadgetRequest).getFetchedDS();
        }
        return gadget != null && gadget.getConfig() != null && gadget.getConfig().getDatasource() != null ? gadget.getConfig().getDatasource().getId() : null;
    }

    private void populateWithFetchedDs(CustomReportsGadgetRequestModel crRequestModel, GadgetModel gadget) {
        DatasourceModel ds = new DatasourceModel();
        ds.setId(crRequestModel.getFetchedDS());
        gadget.getConfig().setDatasource(ds);
    }

    private DatasourceModel retrieveAndPopulateDS(GadgetModel gadget, GadgetRequestModel gadgetRequest) throws GadgetRequesterException {
        if (gadgetRequest instanceof CustomReportsGadgetRequestModel) {
            this.populateWithFetchedDs((CustomReportsGadgetRequestModel)gadgetRequest, gadget);
        }
        DatasourceModel ds = null;
        String dsId = this.getDsId(gadget, null);
        if (dsId != null) {
            try {
                ds = this.dsController.getDatasource(dsId);
                gadget.getConfig().setDatasource(ds);
            }
            catch (IOException ioe) {
                throw new GadgetRequesterException("Invalid datasource", 500);
            }
        }
        return ds;
    }
}

