/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters;

import com.roninpixels.dashboardhub.controllers.gadgets.GadgetsRequesterController;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequesterException;
import com.roninpixels.dashboardhub.gadgetsRequesters.SecureGadgetDefProviderSrv;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customReports.CustomReportsGadgetRequestModel;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customReports.FetchOptions;
import com.roninpixels.dashboardhub.services.DashboardHubPluginManager;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomReportsGadgetRequestService {
    private static final Logger log = LoggerFactory.getLogger(CustomReportsGadgetRequestService.class);
    @Inject
    private GadgetsRequesterController controller;
    @Inject
    private DashboardHubPluginManager dhLicenseManager;
    @Inject
    private SecureGadgetDefProviderSrv securityCheckerSrv;

    public Response doRequest(CustomReportsGadgetRequestModel gadgetRequest) {
        try {
            GadgetModel gadget = this.securityCheckerSrv.checkAndGetStoredGadget(gadgetRequest);
            Map<String, FetchOptions> context = Collections.singletonMap("fetchOptions", gadgetRequest.getFetchOptions());
            return this.doRequest(gadget, gadgetRequest.getExtraParams(), context);
        }
        catch (GadgetRequesterException gre) {
            log.error("Problems with gadget request", (Throwable)gre);
            return ResponseBuilder.createErrorFrom(gre);
        }
    }

    public Response doRequest(GadgetModel gadget, List<String> extraParams, Map context) {
        try {
            if (gadget == null) {
                throw new GadgetRequesterException("INVALID_GADGET", 400);
            }
            if (!this.dhLicenseManager.isLicensed()) {
                throw new GadgetRequesterException("License is not valid", 400);
            }
            Object data = this.controller.getDataFor(gadget, gadget.getConfig().getDatasource(), extraParams, context);
            return ResponseBuilder.ok(data).build();
        }
        catch (BadRequestToSourceException bre) {
            log.error("Request problems for a gadget request");
            return ResponseBuilder.createErrorFrom(bre);
        }
        catch (GadgetRequesterException gre) {
            log.error("Problems with gadget request", (Throwable)gre);
            return ResponseBuilder.createErrorFrom(gre);
        }
        catch (Exception e) {
            log.error("Problems with gadget request", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

