/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.datasources.generators;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.BigPictureConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.datasources.generators.Generator;
import com.roninpixels.dashboardhub.exceptions.BadDatasourceException;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component(value="BigPicture")
public class BigPictureRestDs
implements Generator {
    public static final String PRODUCT = BigPictureConnector.PRODUCT;
    @Inject
    private Crypto mCrypto;
    @Inject
    private ConnectorsFactory connectorsFactory;
    @Inject
    private DHObjectMapper mapper;

    @Override
    public boolean match(DatasourceModel def) {
        return PRODUCT.equals(def.getProduct());
    }

    @Override
    public DatasourceModel generateDS(DatasourceModel dsDef, List<DatasourceModel> datasources, DsOptionsModel options, Object req, Object res) throws Exception {
        String id = UUID.randomUUID().toString();
        String type = this.getType(dsDef);
        DatasourceModel newDs = new DatasourceModel();
        newDs.setId(id);
        newDs.setName(dsDef.getName().trim());
        newDs.setType(type);
        newDs.setProduct(PRODUCT);
        newDs.setPrivate(dsDef.getPrivate());
        newDs.setCreator(dsDef.getCreator());
        newDs.setCreated(new Date());
        if (!type.equals("cloud")) {
            newDs.setUrl(dsDef.getUrl().trim());
        }
        DsOptionsModel tokenData = this.generateDsOptions(newDs, options);
        String token = this.mCrypto.encryptBackend(this.mapper.writeValueAsString(tokenData));
        newDs.setToken(token);
        this.validate(newDs, datasources, type);
        return newDs;
    }

    String getType(DatasourceModel ds) {
        String hostType;
        switch (hostType = ds.getOptions().getOption("hostType")) {
            case "cloud": {
                return "cloud";
            }
            case "self": {
                return "self";
            }
        }
        return "datacenter";
    }

    DsOptionsModel generateDsOptions(DatasourceModel ds, DsOptionsModel options) {
        DsOptionsModel tokenData = new DsOptionsModel();
        tokenData.addOtherConfig("id", ds.getId());
        tokenData.addOtherConfig("name", ds.getName());
        tokenData.addOtherConfig("url", ds.getUrl());
        tokenData.addOtherConfig("product", ds.getProduct());
        tokenData.addOtherConfig("options", options);
        return tokenData;
    }

    public void validate(DatasourceModel dsDef, List<DatasourceModel> datasources, String type) {
        if (!type.equals("cloud") && dsDef.getUrl().trim().isEmpty()) {
            throw new RuntimeException("INVALID_INSTANCE");
        }
        boolean alreadyExists = datasources.stream().anyMatch(ds -> ds.getName().equalsIgnoreCase(dsDef.getName()));
        if (alreadyExists) {
            throw new RuntimeException("CONFLICT");
        }
        try {
            DHConnector connector = this.connectorsFactory.getConnector(dsDef);
            if (!connector.isValid()) {
                throw new BadDatasourceException("INVALID_INSTANCE");
            }
        }
        catch (BadDatasourceException bde) {
            throw bde;
        }
        catch (Exception e) {
            throw new BadDatasourceException("INVALID_INSTANCE", e);
        }
    }
}

