/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.roninpixels.dashboardhub.config.frontedModel.FrontendCacheSettingsModel;
import com.roninpixels.dashboardhub.controllers.FrontendCacheSettingsController;
import com.roninpixels.dashboardhub.exceptions.NotAuthorizedException;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import java.security.GeneralSecurityException;
import java.util.UUID;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FrontendCacheSettingsControllerImpl
implements FrontendCacheSettingsController {
    private static final Logger log = LoggerFactory.getLogger(FrontendCacheSettingsControllerImpl.class);
    static final String PROP_NAME_ENABLED = "com.roninpixels.dashboardhub:frontend.cache.settings.enabled";
    static final String PROP_NAME_SECRET = "com.roninpixels.dashboardhub:frontend.cache.settings.secret";
    @Inject
    @ComponentImport
    private PluginSettingsFactory pluginSettingsFactory;
    @Inject
    private DHUserService userService;
    @Inject
    private Crypto mCrypto;

    String generateSecret(PluginSettings pluginSettings) throws GeneralSecurityException {
        String newSecret = UUID.randomUUID().toString();
        pluginSettings.put(PROP_NAME_SECRET, (Object)this.mCrypto.encryptBackend(newSecret));
        return newSecret;
    }

    @Override
    public void updateCacheSettings(FrontendCacheSettingsModel newConfig) {
        if (!this.userService.isLoggedUserAdmin().booleanValue()) {
            throw new NotAuthorizedException();
        }
        if (newConfig.getEnabled() != null) {
            PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
            pluginSettings.put(PROP_NAME_ENABLED, (Object)newConfig.getEnabled().toString());
        }
    }

    @Override
    public FrontendCacheSettingsModel getCacheSettings() {
        FrontendCacheSettingsModel config = new FrontendCacheSettingsModel();
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        Object enabled = pluginSettings.get(PROP_NAME_ENABLED);
        config.setEnabled(enabled == null ? true : Boolean.parseBoolean(enabled.toString()));
        try {
            Object secret = pluginSettings.get(PROP_NAME_SECRET);
            secret = secret == null ? this.generateSecret(pluginSettings) : this.mCrypto.decryptBackend(secret.toString());
            config.setPersistenceEncryptionPassphrase(secret.toString());
        }
        catch (GeneralSecurityException gse) {
            log.error("Problems getting the frontend encryption passphrase", (Throwable)gse);
        }
        return config;
    }
}

