/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.bigpicture.utils;

import com.roninpixels.dashboardhub.controllers.bigpicture.models.Box;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxField;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxFields;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxFlattened;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxStatus;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxType;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.DataType;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.RawBox;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskBoxFieldValues;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskField;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskFieldValue;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskFieldValueMap;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TasksInBox;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TasksInBoxValue;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TasksInBoxesResponse;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class MappingUtils {
    private MappingUtils() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated.");
    }

    public static Box mapBoxesTree(RawBox cargo, List<Map> boxStatuses) {
        Box boxesTree = new Box(cargo);
        if (cargo.getBoxChildren() != null) {
            List<Box> children = cargo.getBoxChildren().stream().map(box -> MappingUtils.mapBoxesTree(box, boxStatuses)).collect(Collectors.toList());
            boxesTree.setStatus(boxStatuses.stream().filter(boxStatus -> boxStatus.get("id").equals(cargo.getBoxStatus())).findFirst().orElse(null));
            boxesTree.setBoxChildren(children);
        }
        return boxesTree;
    }

    public static String getFieldNameFromLabel(String label) {
        if (label == null) {
            label = "";
        }
        String normalizedLabel = Normalizer.normalize(label, Normalizer.Form.NFKD);
        String labelWithoutAccents = normalizedLabel.replaceAll("\\p{M}", "");
        String cleanedLabel = labelWithoutAccents.replaceAll("[^a-zA-Z0-9 -]", "");
        return MappingUtils.toCamelCase(cleanedLabel);
    }

    public static String toCamelCase(String input) {
        String[] words = input.split("[ -]+");
        StringBuilder result = new StringBuilder(words[0].toLowerCase());
        for (int i = 1; i < words.length; ++i) {
            if (words[i].isEmpty()) continue;
            result.append(Character.toUpperCase(words[i].charAt(0))).append(words[i].substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static Map<String, Object> mapBoxFieldDefinition(Map<String, DataType> dataTypeById, BoxField boxFieldDefinition) {
        String name = MappingUtils.getFieldNameFromLabel(boxFieldDefinition.getBoxFieldLabel());
        DataType dataType = dataTypeById.get(boxFieldDefinition.getDataTypeId());
        List aggregations = Optional.ofNullable(dataType).map(DataType::getAggregations).orElseGet(ArrayList::new);
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        responseData.put("id", boxFieldDefinition.getBoxFieldDefinitionId());
        responseData.put("name", name);
        responseData.put("label", boxFieldDefinition.getBoxFieldLabel());
        responseData.put("dataTypeId", boxFieldDefinition.getDataTypeId());
        responseData.put("aggregations", aggregations);
        return responseData;
    }

    public static Map<String, DataType> keyByDataTypes(List<DataType> dataTypes) {
        if (dataTypes == null) {
            return Collections.emptyMap();
        }
        return dataTypes.stream().filter(Objects::nonNull).filter(dataType -> dataType.getDataTypeId() != null).collect(Collectors.toMap(DataType::getDataTypeId, dataType -> dataType, (existing, replacement) -> existing));
    }

    public static Map<String, String> mapBoxTypeIcon(String rawIcon) {
        if (rawIcon == null) {
            return new HashMap<String, String>(){
                {
                    this.put("name", "");
                    this.put("color", "");
                }
            };
        }
        String[] parts = rawIcon.split("@");
        final String name = parts.length > 0 ? parts[0] : "";
        final String color = parts.length > 1 ? parts[1] : "";
        return new HashMap<String, String>(){
            {
                this.put("name", name);
                this.put("color", color);
            }
        };
    }

    public static Map mapBoxType(BoxType boxType) {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        responseData.put("id", boxType.getBoxTypeId());
        responseData.put("name", boxType.getName());
        responseData.put("icon", MappingUtils.mapBoxTypeIcon(boxType.getIconId()));
        return responseData;
    }

    public static Map mapBoxStatus(BoxStatus boxStatus) {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        responseData.put("id", boxStatus.getId());
        responseData.put("name", boxStatus.getName());
        responseData.put("statusCategory", boxStatus.getStatusCategory());
        return responseData;
    }

    public static List<BoxFlattened> flatBoxChildren(RawBox rootBox) {
        ArrayList<BoxFlattened> result = new ArrayList<BoxFlattened>();
        LinkedList<BoxHierarchyWithMeta> queue = new LinkedList<BoxHierarchyWithMeta>();
        queue.add(new BoxHierarchyWithMeta(rootBox, new ArrayList<String>(), 0, null));
        while (!queue.isEmpty()) {
            BoxHierarchyWithMeta currentMeta = (BoxHierarchyWithMeta)queue.poll();
            RawBox currentBox = currentMeta.box;
            BoxFlattened flatBox = new BoxFlattened(currentBox, currentMeta.parentId, currentMeta.path, currentMeta.depth);
            result.add(flatBox);
            String parentId = currentBox.getBoxId();
            ArrayList<String> currentPath = new ArrayList<String>(currentMeta.path);
            currentPath.add(parentId);
            if (currentBox.getBoxChildren() == null) continue;
            for (RawBox child : currentBox.getBoxChildren()) {
                queue.add(new BoxHierarchyWithMeta(child, currentPath, currentMeta.depth + 1, parentId));
            }
        }
        return result;
    }

    public static List<String> removeEntityFieldsFromList(List<String> fieldIds) {
        if (fieldIds == null) {
            return new ArrayList<String>();
        }
        return fieldIds.stream().filter(fieldId -> fieldId != null && !fieldId.equals("bp-boxes-rd") && !fieldId.equals("bp-tasks-rd")).collect(Collectors.toList());
    }

    public static Map<String, List<String>> mapFieldIdsWithAggregation(List<String> fieldIds) {
        if (fieldIds == null || fieldIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return fieldIds.stream().filter(Objects::nonNull).map(fieldId -> fieldId.split("@", 2)).collect(Collectors.toMap(parts -> parts[0], parts -> new ArrayList<String>(Collections.singletonList(((String[])parts).length > 1 ? parts[1] : "NONE")), (existing, replacement) -> {
            existing.addAll(replacement);
            return existing;
        }));
    }

    public static Map<String, Map<String, Map>> mapBoxFieldValuesFromAPI(Map<String, BoxFields> data, List<String> fieldIds) {
        HashMap<String, Map<String, Map>> valueByFieldIdByBoxId = new HashMap<String, Map<String, Map>>();
        if (data == null || fieldIds == null || fieldIds.isEmpty()) {
            return valueByFieldIdByBoxId;
        }
        for (Map.Entry<String, BoxFields> entry : data.entrySet()) {
            String boxId = entry.getKey();
            BoxFields boxData = entry.getValue();
            if (boxData == null || boxData.getAggregations() == null) continue;
            HashMap<String, Map> valueByFieldId = new HashMap<String, Map>();
            for (String fieldIdAggr : fieldIds) {
                String[] parts = fieldIdAggr.split("@");
                String fieldId = parts[0];
                String aggregationKey = parts.length > 1 ? parts[1] : "NONE";
                Map valuesByAggregationKey = boxData.getAggregations().getOrDefault(fieldId, new HashMap());
                Map value = (Map)valuesByAggregationKey.get(aggregationKey);
                valueByFieldId.put(fieldId, value);
            }
            valueByFieldIdByBoxId.put(boxId, valueByFieldId);
        }
        return valueByFieldIdByBoxId;
    }

    public static List<Map> extractTaskFieldsFromIds(List<String> fieldIds, List<Map> taskFields) {
        if (fieldIds == null || taskFields == null) {
            return Collections.emptyList();
        }
        HashSet<String> fieldIdsSet = new HashSet<String>(fieldIds);
        List<String> fieldIdsEntityRemoved = MappingUtils.removeEntityFieldsFromList(new ArrayList<String>(fieldIdsSet));
        Set taskFieldIds = taskFields.stream().map(field -> field.get("id").toString()).collect(Collectors.toSet());
        return fieldIdsEntityRemoved.stream().filter(taskFieldIds::contains).map(fieldId -> taskFields.stream().filter(field -> field.get("id").toString().equals(fieldId)).findFirst().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Map<String, Object> mapTaskFieldDefinition(TaskField taskField) {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        if (taskField == null) {
            return responseData;
        }
        String name = MappingUtils.getFieldNameFromLabel(Optional.ofNullable(taskField.getFieldName()).orElse(""));
        responseData.put("id", taskField.getFieldId());
        responseData.put("name", name);
        responseData.put("label", taskField.getFieldName());
        responseData.put("dataTypeId", taskField.getDataType());
        return responseData;
    }

    public static List<TaskBoxFieldValues> mapTaskFieldValuesFromAPI(List<TaskFieldValue> taskFieldValues, List<Map> selectedFields, Map<String, List<String>> taskIdsByBoxId) {
        HashMap boxIdByTaskId = new HashMap();
        if (taskIdsByBoxId != null && !taskIdsByBoxId.isEmpty()) {
            taskIdsByBoxId.forEach((boxId, taskIds) -> taskIds.forEach(taskId -> boxIdByTaskId.put(taskId, boxId)));
        }
        return taskFieldValues.stream().map(taskFieldValue -> {
            if (taskFieldValue.getFields() == null) {
                Map<String, TaskFieldValueMap> emptyFields = selectedFields.stream().collect(Collectors.toMap(selectedField -> selectedField.get("id").toString(), selectedField -> new TaskFieldValueMap()));
                return new TaskBoxFieldValues(taskFieldValue.getTaskId(), boxIdByTaskId.getOrDefault(taskFieldValue.getTaskId(), null), emptyFields);
            }
            HashMap<String, Map> fields = new HashMap<String, Map>();
            taskFieldValue.getFields().stream().filter(field -> selectedFields.stream().anyMatch(selectedField -> selectedField.get("label").equals(field.getName()))).forEach(field -> {
                String key = selectedFields.stream().filter(selectedField -> selectedField.get("label").equals(field.getName())).findFirst().map(selectedField -> selectedField.get("id").toString()).orElse(null);
                Map value = field.getValue() == null ? null : (Map)field.getValue();
                fields.put(key, value);
            });
            return new TaskBoxFieldValues(taskFieldValue.getTaskId(), boxIdByTaskId.getOrDefault(taskFieldValue.getTaskId(), null), fields);
        }).collect(Collectors.toList());
    }

    public static Map<String, List<String>> taskIdsByBoxIdFromAPI(TasksInBoxesResponse tasksInBoxesResponse) {
        if (tasksInBoxesResponse == null || tasksInBoxesResponse.getCargo() == null || tasksInBoxesResponse.getCargo().getTaskInBoxes() == null) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> taskIdsByBox = new HashMap<String, List<String>>();
        List<TasksInBox> tasksInBoxes = tasksInBoxesResponse.getCargo().getTaskInBoxes();
        for (TasksInBox taskInBox : tasksInBoxes) {
            String boxId = taskInBox.getBoxId();
            List<TasksInBoxValue> tasks = taskInBox.getTasks();
            List taskIds = tasks.stream().map(task -> String.valueOf(task.getTaskId())).collect(Collectors.toList());
            taskIdsByBox.put(boxId, taskIds);
        }
        return taskIdsByBox;
    }

    private static class BoxHierarchyWithMeta {
        RawBox box;
        List<String> path;
        int depth;
        String parentId;

        public BoxHierarchyWithMeta(RawBox box, List<String> path, int depth, String parentId) {
            this.box = box;
            this.path = path;
            this.depth = depth;
            this.parentId = parentId;
        }
    }
}

