/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.cloud.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class GetAllChangelogEntriesCloudFunc {
    private static final Logger log = LoggerFactory.getLogger(GetAllChangelogEntriesCloudFunc.class);
    static final String PATH_CHANGELOG = "/rest/api/3/issue/%s/changelog";
    static final int MAX_ENTRIES_CLOUD = 1000;
    private ServerConnector connector;

    public GetAllChangelogEntriesCloudFunc(ServerConnector connector) {
        this.connector = connector;
    }

    public Map getData(Long issueId) {
        Boolean isLast;
        String url = String.format(PATH_CHANGELOG, issueId);
        HashMap<String, Integer> mParams = new HashMap<String, Integer>();
        mParams.putIfAbsent("startAt", 0);
        mParams.putIfAbsent("maxResults", 100);
        boolean moreData = true;
        LinkedList elements = new LinkedList();
        do {
            ResponseEntity<Map> response = this.connector.executeRequest(url, mParams, Map.class);
            ResponseChecker.checkStatus(response);
            Map responseData = (Map)response.getBody();
            elements.addAll((List)responseData.get("values"));
            isLast = (Boolean)responseData.get("isLast");
            url = (String)responseData.get("nextPage");
        } while (moreData = isLast == false && url != null && elements.size() < 1000);
        HashMap<String, Serializable> changelog = new HashMap<String, Serializable>();
        changelog.put("startAt", Integer.valueOf(0));
        changelog.put("maxResults", Integer.valueOf(elements.size()));
        changelog.put("total", Integer.valueOf(elements.size()));
        changelog.put("histories", elements);
        return changelog;
    }
}

