/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.factories;

import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.DatasourceBasicAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.JiraAuthenticatorStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.connectors.factories.ConnectorFactory;
import com.roninpixels.dashboardhub.connectors.factories.JiraRestConnectorFactory;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnectorConfiguration;
import com.roninpixels.dashboardhub.connectors.impl.jira.server.JiraRestConnector;
import com.roninpixels.dashboardhub.connectors.impl.projectrak.ProjectrakConnectorServerImpl;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.RestAuthStrategyFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.ServerConnectorFactory;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class ProjectrakRestConnectorFactory
implements ConnectorFactory {
    public static final String RELATIVE_PATH_SERVER = "/rest/projectrak/api/2.0";
    @Inject
    private ServerConnectorFactory serverConnectorFactory;
    @Inject
    private RestAuthStrategyFactory authStrategyFactory;
    @Inject
    private JiraRestConnectorFactory jiraRestConnectorFactory;
    @Inject
    private Crypto crypto;

    RestAuthStrategy getAuthStrategy(DatasourceModel ds, DsOptionsModel options) {
        switch (ds.getType()) {
            case "datacenter": {
                return this.authStrategyFactory.getRestAuthStrategy(DatasourceBasicAuthStrategy.class, ds);
            }
        }
        return this.authStrategyFactory.getRestAuthStrategy(JiraAuthenticatorStrategy.class, ds);
    }

    ServerConnectorConfiguration getConnectorConfig(DatasourceModel ds, DsOptionsModel options) {
        ServerConnectorConfiguration config = new ServerConnectorConfiguration();
        config.setUrlBaseForAPIs(ds.getUrl() + RELATIVE_PATH_SERVER);
        return config;
    }

    @Override
    public DHConnector createConnector(DatasourceModel ds) {
        DsOptionsModel options = DatasourcesUtil.decryptOptions(this.crypto, ds.getToken());
        RestAuthStrategy strategy = this.getAuthStrategy(ds, options);
        ServerConnector connector = this.serverConnectorFactory.getServerConnector(ds, strategy, this.getConnectorConfig(ds, options));
        ServerConnector connector4Jira = this.serverConnectorFactory.getServerConnector(ds, strategy);
        JiraRestConnector jiraConnector = this.jiraRestConnectorFactory.createDefaultConnector(connector4Jira);
        return new ProjectrakConnectorServerImpl(connector, jiraConnector);
    }

    @Override
    public boolean match(DatasourceModel ds) {
        return ds.getProduct().equals("projectrak");
    }
}

