/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.factories;

import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.DatasourceBasicAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.connectors.factories.ConnectorFactory;
import com.roninpixels.dashboardhub.connectors.impl.customReports.CustomReportConnectorImpl;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.RestAuthStrategyFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.ServerConnectorFactory;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.util.Arrays;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class CustomReportsConnectorFactory
implements ConnectorFactory {
    @Inject
    private ServerConnectorFactory serverConnectorFactory;
    @Inject
    private RestAuthStrategyFactory authStrategyFactory;

    @Override
    public DHConnector createConnector(DatasourceModel ds) {
        RestAuthStrategy authStrategy = null;
        if (!"cloud".equals(ds.getType()) || !Arrays.asList("confluence", "jira").contains(ds.getProduct())) {
            throw new RuntimeException(String.format("Datasource not supported - %s/%s", ds.getId(), ds.getType()));
        }
        authStrategy = this.authStrategyFactory.getRestAuthStrategy(DatasourceBasicAuthStrategy.class, ds);
        return new CustomReportConnectorImpl(this.serverConnectorFactory.getServerConnector(ds, authStrategy));
    }

    @Override
    public boolean match(DatasourceModel ds) {
        return false;
    }
}

