/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.factories;

import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.DatasourceBasicAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.JiraAuthenticatorStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.connectors.factories.ConnectorFactory;
import com.roninpixels.dashboardhub.connectors.impl.atlassianInsight.AtlassianAssetsCloudConnectorImpl;
import com.roninpixels.dashboardhub.connectors.impl.atlassianInsight.AtlassianInsightConnectorImpl;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnectorConfiguration;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.RestAuthStrategyFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.ServerConnectorFactory;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class AtlassianInsightRestConnectorFactory
implements ConnectorFactory {
    public static final String RELATIVE_PATH_SERVER = "/rest/assets/1.0";
    public static final String URL_CLOUD_JSM_PATTERN = "https://api.atlassian.com/jsm/assets/workspace/%s/v1";
    @Inject
    private ServerConnectorFactory serverConnectorFactory;
    @Inject
    private RestAuthStrategyFactory authStrategyFactory;
    @Inject
    private Crypto crypto;

    String getHostType(DatasourceModel ds, DsOptionsModel options) {
        return ds.getType() != null ? ds.getType() : options.getOption("hostType");
    }

    RestAuthStrategy getAuthStrategy(DatasourceModel ds, DsOptionsModel options) {
        String type;
        switch (type = this.getHostType(ds, options)) {
            case "cloud": 
            case "datacenter": {
                return this.authStrategyFactory.getRestAuthStrategy(DatasourceBasicAuthStrategy.class, ds);
            }
        }
        return this.authStrategyFactory.getRestAuthStrategy(JiraAuthenticatorStrategy.class, ds);
    }

    ServerConnectorConfiguration getConnectorConfig(DatasourceModel ds, DsOptionsModel options) {
        ServerConnectorConfiguration config = new ServerConnectorConfiguration();
        String type = this.getHostType(ds, options);
        if ("cloud".equals(type)) {
            String workspaceId = this.getWorkspaceId(options);
            if (workspaceId == null) {
                config.setUrlBaseForAPIs(ds.getUrl());
            } else {
                config.setUrlBaseForAPIs(String.format(URL_CLOUD_JSM_PATTERN, workspaceId));
            }
        } else {
            config.setUrlBaseForAPIs(ds.getUrl() + RELATIVE_PATH_SERVER);
        }
        return config;
    }

    @Override
    public DHConnector createConnector(DatasourceModel ds) {
        String type;
        DsOptionsModel options = DatasourcesUtil.decryptOptions(this.crypto, ds.getToken());
        RestAuthStrategy strategy = this.getAuthStrategy(ds, options);
        ServerConnector connector = this.serverConnectorFactory.getServerConnector(ds, strategy, this.getConnectorConfig(ds, options));
        switch (type = this.getHostType(ds, options)) {
            case "cloud": {
                return new AtlassianAssetsCloudConnectorImpl(connector);
            }
        }
        return new AtlassianInsightConnectorImpl(connector);
    }

    @Override
    public boolean match(DatasourceModel ds) {
        return ds.getProduct().equals("atlassian_insight");
    }

    private String getWorkspaceId(DsOptionsModel optionsModel) {
        Map actualOptions = optionsModel.getOption("options", Map.class);
        return actualOptions != null && actualOptions.containsKey("workspaceId") ? (String)actualOptions.get("workspaceId") : null;
    }
}

