/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.authStrategy.strategies;

import com.atlassian.sal.api.net.Response;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import javax.inject.Inject;

public abstract class TokenAuthStrategy
implements RestAuthStrategy {
    protected final String P_TOKEN = "token";
    protected final DatasourceModel datasource;
    @Inject
    protected DHObjectMapper mapper;
    @Inject
    protected Crypto mCrypto;

    public TokenAuthStrategy(DatasourceModel datasource) {
        this.datasource = datasource;
    }

    protected DsOptionsModel getOptions(String token) {
        try {
            return this.mapper.readValue(this.mCrypto.decryptBackend(token), DsOptionsModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void analyzeHeaders(Response response) {
    }
}

