/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.authStrategy;

import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.APITokenAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.BearerTokenAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.DatasourceBasicAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.DatasourceOAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.JiraAuthenticatorStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.OpsgenieTokenAuthStrategy;
import com.roninpixels.dashboardhub.connectors.interfaces.RestAuthStrategyFactory;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
public class RestAuthStrategyFactoryImpl
implements RestAuthStrategyFactory,
BeanFactoryAware {
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Bean
    @Scope(value="prototype")
    public DatasourceBasicAuthStrategy getDatasourceBasicAuthStrategy(DatasourceModel datasource) {
        return new DatasourceBasicAuthStrategy(datasource);
    }

    @Bean
    @Scope(value="prototype")
    public JiraAuthenticatorStrategy getJiraAuthenticatorStrategy(DatasourceModel datasource) {
        return new JiraAuthenticatorStrategy(datasource);
    }

    @Bean
    @Scope(value="prototype")
    public DatasourceOAuthStrategy getDatasourceOAuthStrategy(DatasourceModel datasource) {
        return new DatasourceOAuthStrategy(datasource);
    }

    @Bean
    @Scope(value="prototype")
    public OpsgenieTokenAuthStrategy getOpsgenieAuthStrategy(DatasourceModel datasource) {
        return new OpsgenieTokenAuthStrategy(datasource);
    }

    @Bean
    @Scope(value="prototype")
    public BearerTokenAuthStrategy getBearerTokenAuthStrategy(DatasourceModel datasource) {
        return new BearerTokenAuthStrategy(datasource);
    }

    @Bean
    @Scope(value="prototype")
    public APITokenAuthStrategy getAPITokenAuthStrategy(DatasourceModel datasource) {
        return new APITokenAuthStrategy(datasource);
    }

    @Override
    public <T> T getRestAuthStrategy(Class<T> classType, DatasourceModel ds) {
        return (T)this.beanFactory.getBean(classType, new Object[]{ds});
    }
}

