/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.servicesImpl;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.User;
import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.model.AppUser;
import java.util.Collection;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class AuthenticatedUserServiceImpl
implements DHUserService {
    @ComponentImport
    @Autowired
    private LocaleManager localeManager;
    @ComponentImport
    @Autowired
    @Qualifier(value="com.atlassian.sal.api.user.UserManager")
    private UserManager userManager;
    @ComponentImport
    @Autowired
    private UserAccessor userAccessor;
    @ComponentImport
    @Autowired
    private PermissionManager permissionManager;
    @Inject
    private ApplicationPropertiesAccesor propertiesAccesor;

    @Override
    public AppUser getLoggedInUser() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return null;
        }
        return this.getUserByKey(user.getKey().getStringValue(), false);
    }

    @Override
    public String getLoggedInUserKey() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return user == null ? null : user.getKey().toString();
    }

    @Override
    public AppUser getUserByKey(String userKey) {
        return this.getUserByKey(userKey, false);
    }

    @Override
    public AppUser getUserByKey(String userKey, boolean withAvatars) {
        UserProfile profile = this.userManager.getUserProfile(new UserKey(userKey));
        return this.getUser(withAvatars, profile);
    }

    @Override
    public Boolean isLoggedUserAdmin() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION) || this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    @Override
    public Collection<String> getGroupNamesFor(String userKey) {
        UserProfile userProfile = this.userManager.getUserProfile(new UserKey(userKey));
        return this.userAccessor.getGroupNamesForUserName(userProfile.getUsername());
    }

    @Override
    public AppUser getUserByName(String name, boolean withAvatars) {
        UserProfile profile = this.userManager.getUserProfile(name);
        return this.getUser(withAvatars, profile);
    }

    @Override
    public Boolean isCustomerPortalUser(String userKey) {
        return false;
    }

    private AppUser getUser(boolean withAvatars, UserProfile profile) {
        ConfluenceUserImpl user = (ConfluenceUserImpl)this.userAccessor.getUserByKey(profile.getUserKey());
        AppUser appUser = new AppUser();
        appUser.setKey(user.getKey().getStringValue());
        appUser.setName(user.getName());
        appUser.setDisplayName(user.getFullName());
        appUser.setLocale(this.localeManager.getLocale((User)user));
        try {
            appUser.setActive(true);
        }
        catch (Exception e) {
            appUser.setActive(false);
        }
        if (withAvatars && profile.getProfilePictureUri() != null) {
            appUser.setAvatarUrl(this.propertiesAccesor.getAppProperty("baseURL", "") + profile.getProfilePictureUri().toString());
        }
        return appUser;
    }
}

