/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.actions;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAvailableAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.roninpixels.dashboardhub.config.DashboardHubConfig;
import com.roninpixels.dashboardhub.config.action.DHAction;
import com.roninpixels.dashboardhub.config.action.DHShowAction;
import com.roninpixels.dashboardhub.config.action.DHShowChangeOwnerAction;
import com.roninpixels.dashboardhub.config.action.DHShowGlobalSettingsAction;
import com.roninpixels.dashboardhub.confluence.ContextBridge;
import com.roninpixels.dashboardhub.context.conditions.DHAdminCondition;
import com.roninpixels.dashboardhub.context.conditions.DHAppAccessCondition;
import com.roninpixels.dashboardhub.utils.TokenGeneratorImpl;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DashboardHubAction
extends SpaceAvailableAction
implements SpaceAware {
    private static final Logger log = LoggerFactory.getLogger(DashboardHubAction.class);
    @Autowired
    private TokenGeneratorImpl tokenGenerator;
    private DHAction dhAction;
    private TokenContentModel tokenData;
    private Space mSpace;
    @Autowired
    private DHAppAccessCondition appAccessCondition;
    @Autowired
    private DHAdminCondition adminCondition;

    public String showDashboard() {
        HttpServletRequest request = this.getCurrentRequest();
        this.initAction(request, DHShowAction.class);
        return this.appAccessCondition.matches() ? "success" : "error";
    }

    public String globalSettings() {
        HttpServletRequest request = this.getCurrentRequest();
        this.initAction(request, DHShowGlobalSettingsAction.class);
        return this.adminCondition.matches() ? "success" : "unauthorized";
    }

    public String changeOwner() {
        HttpServletRequest request = this.getCurrentRequest();
        this.initAction(request, DHShowChangeOwnerAction.class);
        return this.adminCondition.matches() ? "success" : "unauthorized";
    }

    public DashboardHubConfig getDashboardHubConfig() {
        return this.dhAction.getDashboardHubConfig();
    }

    public DHAction getDhAction() {
        return this.dhAction;
    }

    private void initAction(HttpServletRequest req, Class<? extends DHAction> actionClass) {
        TokenContentModel tokenContent = this.getTokenData(req, "ac.boardToken");
        this.dhAction = ContextBridge.getComponent(actionClass);
        this.dhAction.setToken(tokenContent);
    }

    private TokenContentModel getTokenData(HttpServletRequest request, String tokenParamName) {
        String token = request.getParameter(tokenParamName);
        if (token != null) {
            try {
                return this.tokenGenerator.getTokenContent(token);
            }
            catch (Exception e) {
                log.error("Problems with a token -> " + token, (Throwable)e);
            }
        }
        return null;
    }

    public void setSpace(Space space) {
        this.mSpace = space;
    }

    public boolean isSpaceRequired() {
        return false;
    }

    public boolean isViewPermissionRequired() {
        return false;
    }

    public Space getSpace() {
        return null;
    }
}

