/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.jira.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.rest.base.jira.api.GenericJiraEndpoint;
import com.roninpixels.dashboardhub.web.rest.base.jira.api.JQLRequest;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/jira/v1/jqlProxy")
public class JQLProxyEndpoint {
    private static final Logger log = LoggerFactory.getLogger(JQLProxyEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;
    @Inject
    private DHUserService dhUserService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response jqlProxy(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, JQLRequest jqlProxyRequest) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            ResponseEntity<String> response = jira.jqlProxy(jqlProxyRequest.getJql(), jqlProxyRequest.getFields(), jqlProxyRequest.getExpand(), jqlProxyRequest.getProperties(), jqlProxyRequest.getExtraOpts(), this.dhUserService.getLoggedInUserKey());
            return GenericJiraEndpoint.generateResponse(response);
        }
        catch (Exception e) {
            if (jqlProxyRequest.getValidating().booleanValue() && e instanceof BadRequestToSourceException) {
                BadRequestToSourceException bre = (BadRequestToSourceException)e;
                return Response.status((int)bre.getStatusCode()).entity(bre.getResponseEntity().getBody()).build();
            }
            log.error("Problems with a jql query (by proxy)", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

