/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dashboardHub.datasources;

import com.roninpixels.dashboardhub.controllers.DatasourcesControllerV2;
import com.roninpixels.dashboardhub.services.DHDefaultConfigGenerator;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.datasources.CreateDatasourceMessage;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.datasources.DatasourcesResponse;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.datasources.ResponseValue;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class DatasourceEndpoint {
    private static final Logger log = LoggerFactory.getLogger(DatasourceEndpoint.class);
    @Inject
    private DHUserService dhUserService;
    @Inject
    private Crypto crypto;
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private DatasourcesControllerV2 dsController;
    @Inject
    private DHDefaultConfigGenerator defaultConfiguration;
    @Inject
    private DHObjectMapper mapper;

    private static void removeToken(DatasourceModel ds) {
        if (ds != null) {
            ds.setToken(null);
        }
    }

    private static void removeTokens(List<DatasourceModel> dsList) {
        dsList.stream().forEach(DatasourceEndpoint::removeToken);
    }

    @GET
    @Path(value="/datasource/{id}")
    @Produces(value={"application/json"})
    public Response getDatasource(@NotNull @PathParam(value="id") String id, @DefaultValue(value="false") @QueryParam(value="private") Boolean isPrivate) {
        try {
            DatasourceModel ds = this.dsController.getDatasource(id);
            DatasourceEndpoint.removeToken(ds);
            return ds == null || ds.getPrivate() == isPrivate ? Response.status((int)404).build() : ResponseBuilder.ok(ds).build();
        }
        catch (Exception e) {
            log.error("Problems getting a datasource: " + id);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Path(value="/datasource")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(CreateDatasourceMessage message) {
        String encryptedData = message.getEncrypted();
        try {
            String data = this.crypto.decryptFrontend(encryptedData);
            DatasourceModel model = this.mapper.readValue(data, DatasourceModel.class);
            AppUser user = this.dhUserService.getLoggedInUser();
            if (model.getId() == null) {
                model.setId(UUID.randomUUID().toString());
            }
            if (model.getCreated() == null) {
                model.setCreated(new Date());
            }
            if (model.getCreator() == null) {
                model.setCreator(user.getKey());
            }
            if (model.getPrivate() == null) {
                model.setPrivate(false);
            }
            if (model.getProduct() == null && !model.getType().equals("token") && !model.getType().equals("dashboard")) {
                model.setProduct(model.getType());
            }
            boolean isDefault = Boolean.TRUE.equals(model.getFirst()) && model.getOptions() == null && this.defaultConfiguration.getDefaultDatasource() == null;
            boolean created = true;
            if (isDefault) {
                this.defaultConfiguration.ensureDefaultDatasource();
            } else {
                created = this.dsController.addDatasource(model, model.getPrivate());
            }
            if (created) {
                List<DatasourceModel> datasources = this.dsController.getDatasources(user.getKey(), isDefault || model.getPrivate() != false);
                DatasourceEndpoint.removeTokens(datasources);
                ResponseValue resValue = new ResponseValue(datasources);
                return ResponseBuilder.ok(resValue).build();
            }
            log.warn("A datasource wasn't added -> " + model.getName());
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            log.error("Problems adding a datasource", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @DELETE
    @Path(value="/datasource/{id}")
    @Produces(value={"application/json"})
    public Response delete(@NotNull @PathParam(value="id") String id, @DefaultValue(value="false") @QueryParam(value="private") Boolean isPrivate) {
        try {
            DatasourceModel ds = this.dsController.removeDatasource(id, isPrivate);
            if (ds == null) {
                return Response.status((int)404).build();
            }
            List<DatasourceModel> datasources = this.dsController.getDatasources(ds.getCreator(), isPrivate);
            DatasourceEndpoint.removeTokens(datasources);
            ResponseValue resValue = new ResponseValue(datasources);
            return ResponseBuilder.create(204, resValue).build();
        }
        catch (Exception e) {
            log.error("Problems deleting a datasource: " + id + "(private -> " + isPrivate + ")", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/datasources")
    @Produces(value={"application/json"})
    public Response getDatasources(@DefaultValue(value="false") @QueryParam(value="private") Boolean isPrivate, @HeaderParam(value="wallboardbehave") String wallBoardBehave) {
        try {
            String userKey = null;
            Object tokenContent = null;
            if (wallBoardBehave != null && !"undefined".equals(wallBoardBehave)) {
                return ResponseBuilder.ok(new DatasourcesResponse("datasources", new ResponseValue())).build();
            }
            AppUser user = this.dhUserService.getLoggedInUser();
            if (user != null) {
                userKey = user.getKey();
            }
            if (userKey == null && isPrivate.booleanValue()) {
                return Response.status((int)404).build();
            }
            List<DatasourceModel> datasources = this.dsController.getDatasources(userKey, isPrivate);
            if (isPrivate.booleanValue() && !datasources.stream().anyMatch(DatasourceModel::getFirst)) {
                this.defaultConfiguration.ensureDefaultDatasource();
                datasources = this.dsController.getDatasources(userKey, true);
            }
            DatasourceEndpoint.removeTokens(datasources);
            ResponseValue value = new ResponseValue(datasources);
            return ResponseBuilder.ok(new DatasourcesResponse("datasources", value)).build();
        }
        catch (Exception e) {
            log.error("Problems getting datasources", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

