/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dashboardHub.dashboardfilters.filterRules;

import com.roninpixels.dashboardhub.confluence.dashboardfilters.web.models.DashboardFilterRule;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.dashboardfilters.filterRules.FilterRulesEndpoint;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.io.IOException;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/filterRules")
public class FilterRulesEndpointWrapper {
    private static final Logger log = LoggerFactory.getLogger(FilterRulesEndpointWrapper.class);
    @Inject
    private FilterRulesEndpoint actualEndpoint;
    @Inject
    private DHObjectMapper mapper;

    @GET
    @Produces(value={"application/json"})
    public Response getFilterRules() {
        Response resp = this.actualEndpoint.getFilterRules();
        return ResponseBuilder.create(resp);
    }

    @GET
    @Path(value="/{key}")
    @Produces(value={"application/json"})
    public Response getFilterRuleByKey(@NotNull @PathParam(value="key") String key) {
        Response resp = this.actualEndpoint.getFilterRuleByKey(key);
        return ResponseBuilder.create(resp);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addFilterRule(String filterRuleRaw) {
        DashboardFilterRule filterRule = null;
        try {
            filterRule = this.mapper.readValue(filterRuleRaw, DashboardFilterRule.class);
        }
        catch (IOException e) {
            return ResponseBuilder.createParseErrorResponse(e);
        }
        Response resp = this.actualEndpoint.addFilterRule(filterRule);
        return ResponseBuilder.create(resp);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateFilterRules(String filterRuleRaw) {
        DashboardFilterRule filterRule = null;
        try {
            filterRule = this.mapper.readValue(filterRuleRaw, DashboardFilterRule.class);
        }
        catch (IOException e) {
            return ResponseBuilder.createParseErrorResponse(e);
        }
        Response resp = this.actualEndpoint.updateFilterRules(filterRule);
        return ResponseBuilder.create(resp);
    }

    @DELETE
    @Path(value="/{key}")
    @Produces(value={"application/json"})
    public Response removeFilterRules(@NotNull @PathParam(value="key") String key) {
        Response resp = this.actualEndpoint.removeFilterRules(key);
        return ResponseBuilder.create(resp);
    }
}

