/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dashboardHub.boards;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.controllers.volatil.UnlockBoardTokenController;
import com.roninpixels.dashboardhub.exceptions.BadRequestException;
import com.roninpixels.dashboardhub.services.PublicLinkSessionService;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import com.roninpixels.dashboardhub.web.models.volatil.UnlockBoardAttemptModel;
import com.roninpixels.dashboardhub.web.rest.base.MessagesUtil;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.boards.UnlockMessageModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/board/unlock")
public class UnlockBoardEndpoint {
    private static final Logger log = LoggerFactory.getLogger(UnlockBoardEndpoint.class);
    private static final int MAX_TRIALS = UnlockBoardTokenController.MAX_TRIALS;
    private static final Long MAX_AGE = 3600000L;
    @Inject
    private BoardsController boardsController;
    @Inject
    private UnlockBoardTokenController unlockController;
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private Crypto crypto;
    @Inject
    private PublicLinkSessionService publicLinkSessionService;

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response unlock(@NotNull UnlockMessageModel message, @Context HttpServletRequest request) {
        String id = message.getBoardId();
        try {
            RequestHandler handler = new RequestHandler(message, request.getCookies());
            UnlockBoardAttemptModel badAttempt = handler.validate();
            if (badAttempt != null) {
                return this.createMaxTrialsReachedResponse(badAttempt, handler);
            }
            TokenContentModel tokenContent = this.tokenGenerator.getTokenContent(message.getBoardToken());
            if (tokenContent.getBoardId() == null || !id.equals(tokenContent.getBoardId())) {
                throw new BadRequestException(404, "BOARDS_DO_NOT_MATCH");
            }
            BoardModel board = this.boardsController.getUserBoard(tokenContent.getUsserAccountId(), id, tokenContent.getGlobal());
            if (board == null || !board.getSharing().getPublic().booleanValue()) {
                throw new BadRequestException(404, "INVALID_BOARD");
            }
            String key = request.getRemoteAddr();
            UnlockBoardAttemptModel lockedAttempt = this.unlockController.getLockedAttempt(key, board.getId());
            if (lockedAttempt != null) {
                return this.createMaxTrialsReachedResponse(lockedAttempt, handler);
            }
            boolean isValid = this.crypto.isHashValid(board.getSharing().getPassword(), message.getPassword());
            if (!isValid) {
                UnlockBoardAttemptModel attempt = this.unlockController.incrementTrial(key, board.getId());
                return this.createBadCredentialsResponse(attempt, handler);
            }
            this.unlockController.removeAttempt(key, board.getId());
            return this.createResponseWithBoard(handler, board, message.getPassword());
        }
        catch (BadRequestException bre) {
            return MessagesUtil.generateErrorResponse(bre.getStatusCode(), bre.getMessage());
        }
        catch (Exception e) {
            log.error("Problems getting a protected board with id -> " + id, (Throwable)e);
            return MessagesUtil.generateErrorResponse(400, "INVALID_BOARD");
        }
    }

    private Response createResponseWithBoard(RequestHandler handler, BoardModel board, String password) throws IOException {
        DHObjectMapperImpl mapper = new DHObjectMapperImpl();
        mapper.enable(SerializationFeature.WRAP_ROOT_VALUE);
        String dhPublicToken = this.publicLinkSessionService.generateToken(board.getToken(), password);
        return Response.ok((Object)mapper.writeValueAsString(board)).header("dhpublicsession", (Object)dhPublicToken).cookie(new NewCookie[]{handler.getNewCookieForTrials(0), handler.getNewCookieForExpirationTime(0L)}).build();
    }

    private Response createBadCredentialsResponse(UnlockBoardAttemptModel attempt, RequestHandler handler) {
        int newTrialsValue = attempt.getTrialNumber();
        long newExpirationAt = attempt.getExpirationTime().getTime();
        HashMap<String, Object> entity = new HashMap<String, Object>();
        entity.put("error", "INVALID_CREDENTIALS");
        entity.put("remaining", MAX_TRIALS - newTrialsValue);
        entity.put("trialNumber", newTrialsValue);
        entity.put("expiresAt", newExpirationAt);
        return Response.status((int)403).cookie(new NewCookie[]{handler.getNewCookieForTrials(newTrialsValue), handler.getNewCookieForExpirationTime(newExpirationAt)}).entity(entity).build();
    }

    private Response createMaxTrialsReachedResponse(UnlockBoardAttemptModel attempt, RequestHandler handler) {
        int trialsValue = attempt.getTrialNumber();
        long expirationAt = attempt.getExpirationTime().getTime();
        HashMap<String, Object> entity = new HashMap<String, Object>();
        entity.put("error", "MAX_TRIALS_REACHED");
        entity.put("remaining", MAX_TRIALS - trialsValue);
        entity.put("trialNumber", trialsValue);
        entity.put("expiresAt", expirationAt);
        return Response.status((int)403).cookie(new NewCookie[]{handler.getNewCookieForTrials(trialsValue), handler.getNewCookieForExpirationTime(expirationAt)}).entity(entity).build();
    }

    class RequestHandler {
        private UnlockMessageModel message;
        private Cookie[] cookies;
        private final String trialsCookieName;
        private final String expirationAtCookieName;

        RequestHandler(UnlockMessageModel message, Cookie[] cookies) {
            this.message = message;
            this.cookies = cookies == null ? new Cookie[]{} : cookies;
            String baseName = String.format("board-trials-%s", message.getBoardId());
            this.trialsCookieName = String.format("%s-t", baseName);
            this.expirationAtCookieName = String.format("%s-d", baseName);
        }

        UnlockBoardAttemptModel validate() throws BadRequestException {
            this.validateInput();
            return this.validateCookie();
        }

        Integer getTrials() {
            Cookie cookie = this.getCookie(this.trialsCookieName);
            return cookie != null ? Integer.parseInt(cookie.getValue()) : 0;
        }

        NewCookie getNewCookieForTrials(int newValue) {
            Cookie cookie = this.getCookie(this.trialsCookieName);
            return this.getNewCookie(cookie, this.trialsCookieName, "" + newValue);
        }

        NewCookie getNewCookieForExpirationTime(long newValue) {
            Cookie cookie = this.getCookie(this.expirationAtCookieName);
            return this.getNewCookie(cookie, this.expirationAtCookieName, "" + newValue);
        }

        private void validateInput() throws BadRequestException {
            String id = this.message.getBoardId();
            if (id == null || this.message.getPassword() == null || this.message.getBoardToken() == null) {
                throw new BadRequestException(400, "INVALID_PARAMS");
            }
        }

        private UnlockBoardAttemptModel validateCookie() throws BadRequestException {
            Long expiresAt = this.getExpirationTime();
            if (expiresAt == null) {
                return null;
            }
            UnlockBoardAttemptModel attempt = new UnlockBoardAttemptModel();
            attempt.setExpirationTime(new Date(expiresAt));
            attempt.setTrialNumber(this.getTrials());
            if (UnlockBoardEndpoint.this.unlockController.getLockedAttempt(attempt) != null) {
                return attempt;
            }
            return null;
        }

        private Cookie getCookie(String name) {
            return Arrays.stream(this.cookies).filter(cookie -> cookie.getName().equals(name)).findAny().orElse(null);
        }

        private Long getExpirationTime() {
            Cookie cookie = this.getCookie(this.expirationAtCookieName);
            return cookie != null ? Long.valueOf(Long.parseLong(cookie.getValue())) : null;
        }

        private NewCookie getNewCookie(Cookie cookie, String name, String newValue) {
            String path = cookie == null ? null : cookie.getPath();
            String domain = cookie == null ? null : cookie.getDomain();
            String comment = cookie == null ? null : cookie.getComment();
            int version = cookie == null ? 1 : cookie.getVersion() + 1;
            return new NewCookie(name, newValue, path, domain, version, comment, MAX_AGE.intValue(), false);
        }
    }
}

