/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dashboardHub.boards;

import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.boards.BoardEndpoint;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.boards.BoardsMessageModel;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.boards.ChangeOwnerMessageModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.io.IOException;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/board")
public class BoardEndpointWrapper {
    private static final Logger log = LoggerFactory.getLogger(BoardEndpointWrapper.class);
    @Inject
    private BoardEndpoint boardEndpoint;
    @Inject
    private DHObjectMapper mapper;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getBoards(@DefaultValue(value="true") @QueryParam(value="global") Boolean global, @DefaultValue(value="false") @QueryParam(value="expand") Boolean expand, @DefaultValue(value="false") @QueryParam(value="sharedWithMe") Boolean sharedWithMe) {
        return this.boardEndpoint.getBoards(global, expand, sharedWithMe);
    }

    @GET
    @Path(value="/admin/all")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getFullBoards() {
        return this.boardEndpoint.getAllBoards();
    }

    @POST
    @Path(value="/admin/changeOwner")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response changeOwner(String message) {
        ChangeOwnerMessageModel changeOwnerMessageModel = null;
        try {
            changeOwnerMessageModel = this.mapper.readValue(message, ChangeOwnerMessageModel.class);
        }
        catch (IOException e) {
            return ResponseBuilder.createParseErrorResponse(e);
        }
        return this.boardEndpoint.changeOwner(changeOwnerMessageModel);
    }

    @PUT
    @Path(value="/admin/disablePublicLink/{boardId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response disablePublicLink(@NotNull @PathParam(value="boardId") String boardId) {
        return this.boardEndpoint.disablePublicLink(boardId);
    }

    @GET
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getBoardById(@NotNull @PathParam(value="id") String id, @DefaultValue(value="true") @QueryParam(value="global") Boolean global) {
        return this.boardEndpoint.getBoardById(id, global);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setBoard(String message) {
        BoardsMessageModel boardsMessageModel = null;
        try {
            boardsMessageModel = this.mapper.readValue(message, BoardsMessageModel.class);
        }
        catch (IOException e) {
            return ResponseBuilder.createParseErrorResponse(e);
        }
        return this.boardEndpoint.setBoard(boardsMessageModel);
    }

    @POST
    @Path(value="/clone/{originalBoardId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response cloneBoard(@NotNull @PathParam(value="originalBoardId") String originalBoardId, String message) {
        BoardsMessageModel boardMessageModel = null;
        try {
            boardMessageModel = this.mapper.readValue(message, BoardsMessageModel.class);
        }
        catch (IOException e) {
            return ResponseBuilder.createParseErrorResponse(e);
        }
        return this.boardEndpoint.cloneBoard(originalBoardId, boardMessageModel);
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setBoard(@NotNull @PathParam(value="id") String id, String message) {
        BoardsMessageModel boardMessageModel = null;
        try {
            boardMessageModel = this.mapper.readValue(message, BoardsMessageModel.class);
        }
        catch (IOException e) {
            return ResponseBuilder.createParseErrorResponse(e);
        }
        return this.boardEndpoint.setBoard(id, boardMessageModel);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response deleteBoardById(@NotNull @PathParam(value="id") String id, @DefaultValue(value="true") @QueryParam(value="global") Boolean global) {
        return this.boardEndpoint.deleteBoardById(id, global);
    }
}

