/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.store.impl.volatil;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.ao.volatil.UnlockBoardAttempt;
import com.roninpixels.dashboardhub.store.volatil.UnlockBoardAttemptsRepository;
import com.roninpixels.dashboardhub.web.models.volatil.UnlockBoardAttemptModel;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UnlockBoardAttemptsRepositoryImp
implements UnlockBoardAttemptsRepository {
    private static final Logger log = LoggerFactory.getLogger(UnlockBoardAttemptsRepositoryImp.class);
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;

    @Inject
    public UnlockBoardAttemptsRepositoryImp(ActiveObjects ao, TransactionTemplate transactionTemplate) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
    }

    private UnlockBoardAttempt find(String key, String boardId) {
        UnlockBoardAttempt[] props = (UnlockBoardAttempt[])this.ao.find(UnlockBoardAttempt.class, "KEY = ? AND BOARD_ID = ?", new Object[]{key, boardId});
        log.debug("unlock attempts found -> " + (Serializable)(props != null ? Integer.valueOf(props.length) : props));
        return props != null && props.length > 0 ? props[0] : null;
    }

    private UnlockBoardAttemptModel tx(UnlockBoardAttempt attempt) {
        UnlockBoardAttemptModel model = new UnlockBoardAttemptModel();
        model.setKey(attempt.getKey());
        model.setBoardId(attempt.getBoardId());
        model.setTrialNumber(attempt.getTrialNumber());
        model.setExpirationTime(attempt.getExpirationTime());
        return model;
    }

    @Override
    public int clean() {
        return (Integer)this.transactionTemplate.execute(() -> {
            Date date = Date.from(LocalDateTime.now().minusDays(1L).atZone(ZoneId.systemDefault()).toInstant());
            return this.ao.deleteWithSQL(UnlockBoardAttempt.class, "EXPIRATION_TIME <= ?", new Object[]{date});
        });
    }

    public boolean saveNew(UnlockBoardAttemptModel attempt) {
        UnlockBoardAttempt attemptBD = (UnlockBoardAttempt)this.ao.create(UnlockBoardAttempt.class, new DBParam[]{new DBParam("KEY", (Object)attempt.getKey()), new DBParam("BOARD_ID", (Object)attempt.getBoardId()), new DBParam("TRIAL_NUMBER", (Object)attempt.getTrialNumber()), new DBParam("EXPIRATION_TIME", (Object)attempt.getExpirationTime())});
        attemptBD.save();
        log.debug("UnlockBoardAttempt saved for -> " + attempt.getKey());
        return true;
    }

    @Override
    public boolean save(UnlockBoardAttemptModel attempt) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            UnlockBoardAttempt attemptBD = this.find(attempt.getKey(), attempt.getBoardId());
            if (attemptBD != null) {
                attemptBD.setTrialNumber(attempt.getTrialNumber());
                attemptBD.setExpirationTime(attempt.getExpirationTime());
                attemptBD.save();
                log.debug("UnlockBoardAttempt updated for -> " + attempt.getKey());
                return true;
            }
            return this.saveNew(attempt);
        });
    }

    @Override
    public UnlockBoardAttemptModel get(String key, String boardId) {
        UnlockBoardAttempt attempt = this.find(key, boardId);
        return attempt == null ? null : this.tx(attempt);
    }

    @Override
    public boolean remove(String key, String boardId) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            UnlockBoardAttempt attemptBD = this.find(key, boardId);
            if (attemptBD != null) {
                this.ao.delete(new RawEntity[]{attemptBD});
                log.debug("UnlockBoardAttempt updated for -> " + key);
                return true;
            }
            return false;
        });
    }
}

