/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.store.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.ao.UserProperty;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.store.UserPropertiesRepository;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.PropertyModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class UserPropertiesRepositoryImpl
implements UserPropertiesRepository {
    private static final Logger log = LoggerFactory.getLogger(UserPropertiesRepositoryImpl.class);
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private DHUserService authenticatedUserService;
    private DHObjectMapper mMapper;

    @Inject
    public UserPropertiesRepositoryImpl(ActiveObjects ao, TransactionTemplate transactionTemplate, DHObjectMapper mapper) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
        this.mMapper = mapper;
    }

    @Inject
    public void setDHUserService(DHUserService dhUserService) {
        this.authenticatedUserService = dhUserService;
    }

    private Map<String, String> getUserProperties(String userKey) {
        UserProperty[] props = (UserProperty[])this.ao.find(UserProperty.class, "USER_KEY = ?", new Object[]{userKey});
        log.debug("User properties found -> " + (Serializable)(props != null ? Integer.valueOf(props.length) : props));
        HashMap<String, String> result = new HashMap<String, String>();
        for (UserProperty prop : props) {
            result.put(prop.getKey(), prop.getValue());
        }
        return result;
    }

    private Map<String, String> getUserProperties() {
        String userKey = this.authenticatedUserService.getLoggedInUser().getKey();
        return this.getUserProperties(userKey);
    }

    private UserProperty findUserProperty(String userKey, String propertyKey) {
        Query query = Query.select().where("USER_KEY = ? AND KEY = ?", new Object[]{userKey, propertyKey});
        UserProperty[] userProps = (UserProperty[])this.ao.find(UserProperty.class, query);
        if (userProps.length == 0) {
            return null;
        }
        if (userProps.length > 1) {
            throw new RuntimeException(String.format("The user has more than one property with same key: %s // %s", userKey, propertyKey));
        }
        return userProps[0];
    }

    @Override
    public Collection<String> getAllKeys() {
        return this.getUserProperties().keySet();
    }

    @Override
    public boolean addUserProperty(PropertyModel property) throws IOException {
        String valueStr;
        if (property == null || property.getValue() == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        AppUser user = this.authenticatedUserService.getLoggedInUser();
        if (user == null) {
            throw new RuntimeException("There is no logged in user. This action cannot be performed");
        }
        String userKey = user.getKey();
        return null != this.transactionTemplate.execute(() -> this.lambda$addUserProperty$0(userKey, property, valueStr = this.mMapper.writeValueAsString(property)));
    }

    @Override
    public boolean updateUserProperty(String userKey, PropertyModel property) throws IOException {
        String valueStr;
        if (property == null || property.getKey() == null) {
            throw new IllegalArgumentException("Null key is not allowed");
        }
        if (property.getValue() == null) {
            throw new IllegalArgumentException("Null value is not allowed");
        }
        String actualUserKey = this.getActualUser(userKey);
        UserProperty updatedProperty = (UserProperty)this.transactionTemplate.execute(() -> this.lambda$updateUserProperty$1(actualUserKey, property, valueStr = this.mMapper.writeValueAsString(property)));
        return updatedProperty != null;
    }

    @Override
    public boolean updateUserProperty(PropertyModel property) throws IOException {
        return this.updateUserProperty(null, property);
    }

    @Override
    public <T> T getUserProperty(String key, Class<T> expectedClass) throws IOException {
        return this.getUserProperty(null, key, expectedClass);
    }

    @Override
    public <T> T getUserProperty(String userKey, String key, Class<T> expectedClass) throws IOException {
        String actualUserKey = userKey == null ? this.authenticatedUserService.getLoggedInUser().getKey() : userKey;
        UserProperty userProp = this.findUserProperty(actualUserKey, key);
        if (userProp != null) {
            String json = userProp.getValue();
            return json == null ? null : (T)this.mMapper.readValue(json, expectedClass);
        }
        return null;
    }

    @Override
    public boolean removeUserProperty(String key) {
        return this.removeUserProperty(null, key);
    }

    @Override
    public boolean removeUserProperty(String userKey, String key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key is not allowed");
        }
        String actualUserKey = this.getActualUser(userKey);
        UserProperty removedProperty = (UserProperty)this.transactionTemplate.execute(() -> {
            UserProperty userProp = this.findUserProperty(actualUserKey, key);
            if (userProp != null) {
                this.ao.delete(new RawEntity[]{userProp});
                log.debug(String.format("User property deleted -> %s // %s", userKey, key));
            }
            return userProp;
        });
        return removedProperty != null;
    }

    private String getActualUser(String userKey) {
        AppUser user = null;
        if (userKey == null && (user = this.authenticatedUserService.getLoggedInUser()) == null) {
            throw new RuntimeException("There is no logged in user. This action cannot be performed");
        }
        return userKey != null ? userKey : user.getKey();
    }

    private /* synthetic */ UserProperty lambda$updateUserProperty$1(String actualUserKey, PropertyModel property, String valueStr) {
        UserProperty userProp = this.findUserProperty(actualUserKey, property.getKey());
        if (userProp != null) {
            userProp.setValue(valueStr);
            userProp.save();
            log.debug(String.format("User property updated -> %s // %s", actualUserKey, property.getKey()));
        } else {
            log.warn(String.format("User property not found (update action) -> %s // %s", actualUserKey, property.getKey()));
        }
        return userProp;
    }

    private /* synthetic */ UserProperty lambda$addUserProperty$0(String userKey, PropertyModel property, String valueStr) {
        UserProperty userProp = this.findUserProperty(userKey, property.getKey());
        if (userProp != null) {
            return null;
        }
        userProp = (UserProperty)this.ao.create(UserProperty.class, new DBParam[]{new DBParam("USER_KEY", (Object)userKey), new DBParam("KEY", (Object)property.getKey()), new DBParam("VALUE", (Object)valueStr)});
        userProp.save();
        log.debug(String.format("User property saved -> %s // %s", userKey, property.getKey()));
        return userProp;
    }
}

