/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.services.impl;

import com.roninpixels.dashboardhub.exceptions.DHValidationException;
import com.roninpixels.dashboardhub.services.DHSessionService;
import com.roninpixels.dashboardhub.services.impl.DHSession;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class DHSessionServiceImpl
implements DHSessionService {
    public static final long SESSION_TIME_LIFE = 1800000L;
    @Inject
    private Crypto mCrypto;
    @Inject
    private DHObjectMapper dhObjectMapper;

    private long getNextExpirationTime(long currentET) {
        return currentET + 1800000L;
    }

    private String serialize(DHSession session) {
        try {
            String serializedSession = this.dhObjectMapper.writeValueAsString(session);
            return this.mCrypto.encryptBackend(serializedSession);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String generateToken(boolean isExternal) {
        DHSession session = new DHSession();
        session.setExternal(isExternal);
        return this.renovate(session);
    }

    @Override
    public String renovate(DHSession session) {
        DHSession newSession = new DHSession();
        newSession.setExternal(session.isExternal());
        newSession.setExpirationTime(this.getNextExpirationTime(System.currentTimeMillis()));
        return this.serialize(newSession);
    }

    @Override
    public DHSession validateToken(String token) throws DHValidationException {
        try {
            String serializedSession = this.mCrypto.decryptBackend(token);
            DHSession session = this.dhObjectMapper.readValue(serializedSession, DHSession.class);
            if (session.getExpirationTime() < System.currentTimeMillis()) {
                throw new DHValidationException("SESSION_EXPIRED");
            }
            return session;
        }
        catch (DHValidationException ve) {
            throw ve;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

