/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.projectrak;

import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.projectrak.ProjectrakGadgetRequesterBase;
import com.roninpixels.dashboardhub.gadgetsRequesters.projectrak.ProjectsTimelineConfig;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ProjectsTimeline
extends ProjectrakGadgetRequesterBase {
    private static final Logger log = LoggerFactory.getLogger(ProjectsTimeline.class);
    private static final List<String> TARGET_FIELDS = Arrays.asList("key", "name");
    private static final List<String> STATUS_CATEGORIES = Arrays.asList("new", "indeterminate", "done");
    static final String JQL_FORMAT = "project = \"%s\" and statusCategory = \"%s\"";
    private static DHObjectMapper mapper = new DHObjectMapperImpl();
    JiraConnector jiraConnector;

    @Override
    public void init(DatasourceModel ds, Map context) {
        super.init(ds, context);
        this.jiraConnector = this.connector.getJiraConnector();
    }

    List<Integer> getFieldIds(ProjectsTimelineConfig config) {
        List<Integer> ids = this.getFieldsIds(TARGET_FIELDS);
        ids.add(config.getStartDateField());
        ids.add(config.getEndDateField());
        return ids;
    }

    List<Map> getProjects(ProjectsTimelineConfig config) {
        List<Integer> fieldIds = this.getFieldIds(config);
        return this.connector.execPQL(config.getPQL(), fieldIds, true);
    }

    Integer getIssuesCounter(String projectKey, String statusCategory) {
        String jql = String.format(JQL_FORMAT, projectKey, statusCategory);
        HashMap<String, Integer> extraOpts = new HashMap<String, Integer>();
        extraOpts.put("maxResults", 0);
        ResponseEntity<String> res = this.jiraConnector.jqlProxy(jql, null, null, null, extraOpts, null);
        this.checkStatus(res);
        try {
            Map data = mapper.readValue((String)res.getBody(), Map.class);
            return (Integer)data.get("total");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    List<Map> populateWithIssuesReport(List<Map> projects) {
        projects.stream().forEach(project -> {
            Map actualProject = (Map)project.get("project");
            String key = (String)actualProject.get("key");
            ConcurrentHashMap report = new ConcurrentHashMap();
            STATUS_CATEGORIES.parallelStream().forEach(statusCategory -> {
                Integer issuesCounter = this.getIssuesCounter(key, (String)statusCategory);
                report.put(statusCategory, issuesCounter);
            });
            actualProject.put("issuesReport", report);
        });
        return projects;
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        ProjectsTimelineConfig config = GadgetRequesterUtils.getConfig(gadget, ProjectsTimelineConfig.class);
        try {
            List<Map> projects = this.getProjects(config);
            List<Map> finalProjects = this.populateWithIssuesReport(projects);
            HashMap<String, List<Map>> response = new HashMap<String, List<Map>>();
            response.put("projects", finalProjects);
            return response;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

