/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.projectrak;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.ProjectrakConnector;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequester;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

public abstract class ProjectrakGadgetRequesterBase
implements GadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(ProjectrakGadgetRequesterBase.class);
    @Inject
    private ConnectorsProvider provider;
    ProjectrakConnector connector;
    @Inject
    private DHObjectMapper mapper;
    protected Map context;

    @Override
    public void init(DatasourceModel datasource, Map context) {
        this.connector = (ProjectrakConnector)this.provider.getConnector(datasource);
        if (this.connector == null) {
            throw new IllegalArgumentException("Datasource is not valid for gadget requester: " + (Annotation)this.getClass().getAnnotation(Component.class));
        }
        this.context = context;
    }

    protected void checkStatus(ResponseEntity response) {
        ResponseChecker.checkStatus(response);
    }

    List<Integer> getFieldsIds(List<String> fieldsKeys) {
        List actualKeys = fieldsKeys.stream().map(String::toLowerCase).collect(Collectors.toList());
        List<Map> fields = this.connector.getFields(true);
        return fields.stream().filter(field -> {
            String name = field.getOrDefault("name", "");
            String fieldKey = name.replaceAll("\\s", "").toLowerCase(Locale.ROOT);
            String pql = null;
            if (field.containsKey("pql")) {
                pql = (String)((Map)field.get("pql")).get("token");
            }
            return pql != null && actualKeys.contains(pql) || actualKeys.contains(fieldKey);
        }).map(field -> (Integer)field.get("id")).collect(Collectors.toList());
    }

    List<Integer> getFieldsIds() {
        List<Map> fields = this.connector.getFields(true);
        return fields.stream().map(field -> (Integer)field.get("id")).collect(Collectors.toList());
    }
}

