/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.opsgenie;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.OpsgenieConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequester;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

public abstract class OpsgenieGadgetRequesterBase
implements GadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(OpsgenieGadgetRequesterBase.class);
    @Inject
    private ConnectorsProvider provider;
    OpsgenieConnector connector;
    @Inject
    private DHObjectMapper mapper;
    protected Map context;

    @Override
    public void init(DatasourceModel datasource, Map context) {
        this.connector = (OpsgenieConnector)this.provider.getConnector(datasource);
        if (this.connector == null) {
            throw new IllegalArgumentException("Datasource is not valid for gadget requester: " + (Annotation)this.getClass().getAnnotation(Component.class));
        }
        this.context = context;
    }

    protected void checkStatus(ResponseEntity<?> response) throws Exception {
        if (response.getStatusCode().value() >= 400) {
            throw new BadRequestToSourceException(response);
        }
    }

    protected <T> T checkStatusAndParse(ResponseEntity<String> response, Class<T> clazz) throws Exception {
        this.checkStatus(response);
        return this.mapper.readValue((String)response.getBody(), clazz);
    }

    boolean checkGetUsers(List<String> extraParams) {
        return extraParams.size() > 0 && Boolean.parseBoolean(extraParams.get(0));
    }

    List getUsers() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("loadAll", "true");
        ResponseEntity<List> resp = this.connector.listUsers(params);
        this.checkStatus(resp);
        return (List)resp.getBody();
    }
}

