/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class JiraDateUtils {
    public static final DateTimeFormatter DEFAULT_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static ZonedDateTime getZonedDateTime(String strDate) {
        ZonedDateTime releasedDT;
        try {
            releasedDT = ZonedDateTime.parse(strDate);
        }
        catch (NullPointerException ne) {
            releasedDT = LocalDateTime.parse(strDate).atZone(ZoneId.systemDefault());
        }
        catch (DateTimeException e) {
            releasedDT = LocalDate.parse(strDate, DEFAULT_DATE_FORMATTER).atStartOfDay(ZoneId.systemDefault());
        }
        return releasedDT;
    }

    public static final long getMillisFrom(String strDate) {
        return JiraDateUtils.getZonedDateTime(strDate).toInstant().toEpochMilli();
    }
}

