/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.exceptions.GadgetBadConfigException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.CycleLeadTimeConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.EpicProgress;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.ReportingEntityType;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CycleLeadTime
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(EpicProgress.class);
    static final String FIELD_ASSIGNEE = "assignee";
    static final String FIELD_PROJECT = "project";
    static final String FIELD_SPRINT = "sprint";
    static final String FIELD_EPIC_LINK = "Epic Link";
    static final List<String> DEFAULT_ISSUE_FIELDS = Arrays.asList("status", "id", "created", "issuetype");
    static final List<String> EXPAND_VALUE = Arrays.asList("changelog");
    static final List<String> DEFAULT_EPICS_FIELDS = Arrays.asList("summary");

    String getJQL(CycleLeadTimeConfig config, List<String> extraParams) {
        String jql;
        switch (config.getReportingEntityType()) {
            case assignees: {
                List<String> assignees = config.getAssignees();
                if (assignees == null || assignees.isEmpty()) {
                    throw new GadgetBadConfigException("Assignees can not be empty");
                }
                jql = String.format("%s in ('%s')", FIELD_ASSIGNEE, assignees.stream().collect(Collectors.joining("','")));
                break;
            }
            case epics: {
                List<String> epics = config.getEpics();
                if (epics == null || epics.isEmpty()) {
                    throw new GadgetBadConfigException("Epics can not be empty");
                }
                jql = String.format("'%s' in (%s)", FIELD_EPIC_LINK, epics.stream().collect(Collectors.joining(",")));
                break;
            }
            case customJQL: {
                jql = config.getFilter().getJql();
                break;
            }
            case projects: {
                List<String> projects = config.getProjects();
                if (projects == null || projects.isEmpty()) {
                    throw new GadgetBadConfigException("Projects can not be empty");
                }
                jql = String.format("%s in (%s)", FIELD_PROJECT, projects.stream().collect(Collectors.joining(",")));
                break;
            }
            default: {
                throw new RuntimeException("ReportingEntityType not supported: " + config.getReportingEntityType());
            }
        }
        return jql;
    }

    List<String> getAggregationField(CycleLeadTimeConfig config, List<String> extraParams) {
        LinkedList<String> fieldKeys = new LinkedList<String>();
        switch (config.getReportingEntityType()) {
            case assignees: {
                fieldKeys.add(FIELD_ASSIGNEE);
                break;
            }
            case epics: {
                String fieldKey = extraParams != null && extraParams.size() > 0 ? extraParams.get(0) : FIELD_EPIC_LINK;
                fieldKeys.add(fieldKey);
                fieldKeys.add("parent");
                break;
            }
            case projects: {
                fieldKeys.add(FIELD_PROJECT);
                break;
            }
            case customJQL: {
                break;
            }
            default: {
                throw new RuntimeException("ReportingEntityType not supported: " + config.getReportingEntityType());
            }
        }
        return fieldKeys;
    }

    String getExcludeIssueTypeJQL(CycleLeadTimeConfig config) {
        String jqlExcludedIssueType = "";
        List<String> excludedIssueTypes = config.getExcludedIssueTypes();
        if (!ReportingEntityType.customJQL.equals((Object)config.getReportingEntityType()) && excludedIssueTypes != null && !excludedIssueTypes.isEmpty()) {
            jqlExcludedIssueType = String.format(" AND issueType not in (%s)", excludedIssueTypes.stream().map(type -> type.contains(" ") ? String.format("'%s'", type) : type).collect(Collectors.joining(",")));
        }
        return jqlExcludedIssueType;
    }

    String getEffectiveAggField(List<String> aggregationFields, List<Map> issues) {
        String aggField = aggregationFields.stream().filter(fieldKey -> {
            Optional<Map> r = issues.stream().filter(issue -> ((Map)issue.get("fields")).get(fieldKey) != null).findAny();
            return r != null;
        }).findAny().orElse("");
        return aggField;
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        CycleLeadTimeConfig config = GadgetRequesterUtils.getConfig(gadget, CycleLeadTimeConfig.class);
        try {
            String jql = this.getJQL(config, extraParams);
            List<String> excludedIssueTypes = config.getExcludedIssueTypes();
            List<String> aggregationFields = this.getAggregationField(config, extraParams);
            ArrayList<String> fields = new ArrayList<String>(DEFAULT_ISSUE_FIELDS);
            if (aggregationFields != null) {
                fields.addAll(aggregationFields);
            }
            List instanceFields = this.getFields();
            List<Map> _issues = super.execJQLwithFilterFields(jql, fields, instanceFields, EXPAND_VALUE, null, null, null).getIssues();
            List<Map> issues = _issues.stream().filter(issue -> {
                if (!ReportingEntityType.customJQL.equals((Object)config.getReportingEntityType()) && excludedIssueTypes != null && !excludedIssueTypes.isEmpty()) {
                    Map issueType = (Map)((Map)issue.get("fields")).get("issuetype");
                    return !excludedIssueTypes.contains(issueType.get("name"));
                }
                return true;
            }).collect(Collectors.toList());
            String aggField = this.getEffectiveAggField(aggregationFields, issues);
            HashMap<String, Object> responseObj = new HashMap<String, Object>();
            responseObj.put("aggregationField", aggField);
            responseObj.put("issues", issues);
            return responseObj;
        }
        catch (GadgetBadConfigException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }
}

