/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket;

import com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket.BitbucketGadgetRequesterBase;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class StateOfDev
extends BitbucketGadgetRequesterBase {
    private static final Logger log = LoggerFactory.getLogger(StateOfDev.class);

    List<Map> getRepositories() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", "100");
        ResponseEntity<List> res = this.connector.searchRepositories(params, true);
        this.checkStatus(res);
        return (List)res.getBody();
    }

    String getProjectKey(Map repo) {
        Object rawPrj = repo.get("project");
        if (rawPrj == null) {
            return null;
        }
        return (String)((Map)rawPrj).get("key");
    }

    int countPullRequests(List<Map> repos) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("state", "MERGED");
        return repos.stream().map(repo -> {
            String slug = (String)repo.get("slug");
            String project = this.getProjectKey((Map)repo);
            ResponseEntity<Integer> res = this.connector.countPullRequests(project, slug, params);
            if (res.getStatusCodeValue() < 400) {
                return (Integer)res.getBody();
            }
            log.warn(String.format("Count pull requests for slug \"%s\" has failed -> %s", slug, res.getStatusCodeValue()));
            return 0;
        }).reduce(0, Integer::sum);
    }

    int countMembers() {
        ResponseEntity<Integer> res = this.connector.countWorkspaceMembers();
        return res.getStatusCodeValue() >= 400 ? -1 : (Integer)res.getBody();
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        List<Map> repositories = this.getRepositories();
        int prs = this.countPullRequests(repositories);
        int members = this.countMembers();
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("repositories", repositories.size());
        data.put("members", members);
        data.put("pullRequests", prs);
        return data;
    }
}

