/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.config.frontedModel.PublicLinkSettingsModel;
import com.roninpixels.dashboardhub.controllers.DHPermissionController;
import com.roninpixels.dashboardhub.controllers.PublicLinkManagementController;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class PublicLinkManagementControllerImpl
implements PublicLinkManagementController {
    @Inject
    @ComponentImport
    private PluginSettingsFactory pluginSettingsFactory;
    @Inject
    @ComponentImport
    private TransactionTemplate transactionTemplate;
    @Inject
    private DHPermissionController permissionController;

    PublicLinkSettingsModel _updateConfig(PublicLinkSettingsModel newConfig) {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put("com.roninpixels.dashboardhub:publicLink.management.restricted", (Object)newConfig.getRestricted().toString());
        if (newConfig.getRestricted().booleanValue()) {
            List<String> usersGroups = newConfig.getAllowedUsersGroups();
            this.permissionController.updateConfig(usersGroups, 101, "publicLink");
        } else {
            this.permissionController.deletePermissions(101, "publicLink");
        }
        return this._getConfig();
    }

    @Override
    public PublicLinkSettingsModel updateSettings(PublicLinkSettingsModel newConfig) {
        return (PublicLinkSettingsModel)this.transactionTemplate.execute(() -> this._updateConfig(newConfig));
    }

    PublicLinkSettingsModel _getConfig() {
        PublicLinkSettingsModel config = new PublicLinkSettingsModel();
        config.setRestricted(this.isCreationRestricted());
        if (config.getRestricted().booleanValue()) {
            List<String> groupsAndUsers = this.permissionController.getUsersAndGroups(101, "publicLink");
            config.setAllowedUsersGroups(groupsAndUsers);
        }
        return config;
    }

    @Override
    public PublicLinkSettingsModel getSettings() {
        return (PublicLinkSettingsModel)this.transactionTemplate.execute(() -> this._getConfig());
    }

    @Override
    public boolean isCreationRestricted() {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        String restrictedStr = (String)settings.get("com.roninpixels.dashboardhub:publicLink.management.restricted");
        return restrictedStr != null && Boolean.parseBoolean(restrictedStr);
    }

    @Override
    public boolean canUserCreatePublicLinks(String userKey) {
        return !this.isCreationRestricted() || this.permissionController.isUserAllowedFor(userKey, 101);
    }
}

