/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.roninpixels.dashboardhub.connectors.interfaces.ConfluenceConnector;
import com.roninpixels.dashboardhub.controllers.ConfluenceUsersController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConfluenceUsersControllerImpl
implements ConfluenceUsersController {
    private final ConfluenceConnector confConnector;

    public ConfluenceUsersControllerImpl(ConfluenceConnector confConnector) {
        this.confConnector = confConnector;
    }

    @Override
    public List<Map> getBulkUsers(List<String> userKeys, List<String> userNames, int maxResults) {
        ArrayList<Map> users = new ArrayList<Map>();
        if (userKeys != null && !userKeys.isEmpty()) {
            users.addAll(this.confConnector.getUsersByUserKeys(userKeys));
        }
        if (userNames != null && !userNames.isEmpty()) {
            users.addAll(this.confConnector.getUsersByUsername(userNames));
        }
        return users;
    }

    @Override
    public List<Map> getBulkGroups(List<String> groupNames, int maxResults) {
        return this.confConnector.getGroupsByGroupNames(groupNames);
    }

    @Override
    public List<Map> searchUsers(String searchTerm, int maxResults) {
        List<Map> users = this.confConnector.searchUsers(searchTerm, maxResults);
        return users.stream().filter(user -> user.get("username") != null && !user.get("username").toString().startsWith("addon_")).collect(Collectors.toList());
    }
}

