/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.ImageProvider;
import com.roninpixels.dashboardhub.exceptions.ImageTypeException;
import com.roninpixels.dashboardhub.store.DHDatasourcesRepository;
import com.roninpixels.dashboardhub.utils.images.ImageUtil;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.ImageMimeTypeModel;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ImageController {
    private static final Logger log = LoggerFactory.getLogger(ImageController.class);
    @Autowired
    private DHDatasourcesRepository dsRepo;
    @Autowired
    private ConnectorsFactory connectorsFactory;

    public ImageMimeTypeModel getImageByteArray(String datasourceId, String route) throws Exception {
        DatasourceModel ds = this.dsRepo.getDatasource(datasourceId);
        DHConnector dhConnector = this.connectorsFactory.getConnector(ds);
        if (!(dhConnector instanceof ImageProvider)) {
            log.error("Get image not implemented for " + ds.getProduct());
            throw new UnsupportedOperationException("Get image not implemented for " + ds.getProduct());
        }
        ResponseEntity<InputStream> imageInputStream = ((ImageProvider)((Object)dhConnector)).getImage(route);
        byte[] inputStream = IOUtils.toByteArray((InputStream)((InputStream)imageInputStream.getBody()));
        String mimeType = ImageUtil.getImageMimeType(inputStream);
        if (mimeType == null || !mimeType.startsWith("image/")) {
            throw new ImageTypeException("File type not allowed");
        }
        return new ImageMimeTypeModel(mimeType, inputStream);
    }
}

