/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.projectrak.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class PQLExecFunc {
    private static final Logger log = LoggerFactory.getLogger(PQLExecFunc.class);
    public static final String PATH = "/search/projects";
    static final List<String> FIELD_TYPES_USER = Arrays.asList("user", "user_multi", "lead");
    static final List<String> FIELD_TYPES_PROJECT = Arrays.asList("project_multi");
    static final String PATH_PROJECT_SELF_PTRN = "%s/projects/%s";
    static final String PATH_USER_PROFILE = "%s/secure/ViewProfile.jspa?name=%s";
    private final ServerConnector connector;

    public PQLExecFunc(ServerConnector connector) {
        this.connector = connector;
    }

    List execPQL(String pql, boolean loadAll) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pql", pql);
        params.put("expand", "avatar,fields");
        LinkedList projects = new LinkedList();
        int page = 1;
        boolean hasMore = true;
        while (hasMore) {
            params.put("page", "" + page++);
            ResponseEntity<Map> res = this.connector.executeRequest(PATH, params, Map.class);
            ResponseChecker.checkStatus(res);
            Map body = (Map)res.getBody();
            List resProjects = (List)((Map)body.get("_embedded")).get("projects");
            projects.addAll(resProjects);
            boolean more = ((Map)body.get("_links")).containsKey("next");
            hasMore = loadAll && more && projects.size() < 1000;
        }
        return projects;
    }

    private String getBaseURL() {
        String baseUrl = this.connector.getURL().split("/rest/")[0];
        if (baseUrl.substring(baseUrl.length() - 1).equals("/")) {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    String getPathProjectSelfPtrn(String projectKey) {
        String base = this.getBaseURL();
        return String.format(PATH_PROJECT_SELF_PTRN, base, projectKey);
    }

    String getPathUserProfile(String userKey) {
        String base = this.getBaseURL();
        return String.format(PATH_USER_PROFILE, base, userKey);
    }

    List<Map> filterAndTxFields(List<Map> allFields, List<Integer> fieldsIds) {
        return allFields.stream().filter(field -> {
            Integer id = (Integer)((Map)field.get("field")).get("id");
            return fieldsIds.contains(id);
        }).collect(Collectors.toList());
    }

    Map transformUserData(Map rawUserData) {
        Map data = (Map)rawUserData.get("value");
        String username = (String)data.get("username");
        String userProfileUrl = this.getPathUserProfile(username);
        HashMap<String, String> userData = new HashMap<String, String>(data);
        userData.put("profileUrl", userProfileUrl);
        userData.remove("emailAddress");
        HashMap<String, Object> txValue = new HashMap<String, Object>();
        txValue.put("value", username);
        txValue.put("userData", userData);
        return txValue;
    }

    Map transformProjectData(Map rawProjectData) {
        HashMap<String, Object> projectData = new HashMap<String, Object>();
        projectData.putAll(rawProjectData);
        projectData.remove("fields");
        projectData.remove("versions");
        projectData.remove("leadUserKey");
        projectData.remove("leadUserName");
        projectData.remove("description");
        String projectKey = (String)rawProjectData.get("key");
        projectData.put("self", this.getPathProjectSelfPtrn(projectKey));
        if (rawProjectData.containsKey("leadUserKey")) {
            HashMap lead = new HashMap();
            lead.put("key", rawProjectData.get("leadUserKey"));
            projectData.put("lead", lead);
        }
        return projectData;
    }

    Map transformRawField(Map field) {
        Object rawValue;
        Object txValue;
        Map rawField = (Map)field.get("field");
        HashMap txField = new HashMap(rawField);
        if (txField.containsKey("pql")) {
            txField.remove("pql");
            txField.put("pqlKey", ((Map)rawField.get("pql")).get("token"));
        }
        Object object = txValue = this.isNullValue(rawValue = field.get("value")) ? null : (Object)rawValue;
        if (txValue != null) {
            String fieldType = (String)rawField.get("type");
            if (FIELD_TYPES_USER.contains(fieldType)) {
                txValue = fieldType.equals("user_multi") ? ((List)txValue).stream().map(this::transformUserData).collect(Collectors.toList()) : this.transformUserData((Map)rawValue);
            } else if (FIELD_TYPES_PROJECT.contains(fieldType)) {
                txValue = ((List)txValue).stream().map(value -> {
                    Map rawPrj = (Map)value.get("value");
                    Map txPrj = this.transformProjectData(rawPrj);
                    HashMap<String, Map> newValue = new HashMap<String, Map>(rawPrj);
                    newValue.put("value", txPrj);
                    return newValue;
                }).collect(Collectors.toList());
            }
        }
        HashMap<String, Map> data = new HashMap<String, Map>();
        data.put("field", txField);
        data.put("value", (Map)txValue);
        return data;
    }

    private boolean isNullValue(Object rawValue) {
        return rawValue == null || rawValue instanceof Map && ((Map)rawValue).get("value") == null;
    }

    List<Map> transformRawProjects(List<Map> projects, List<Integer> fieldsIds) {
        return projects.stream().map(project -> {
            Map projectData = this.transformProjectData((Map)project);
            HashMap<String, Object> base = new HashMap<String, Object>();
            base.put("project", projectData);
            List<Map> rawFields = project.getOrDefault("fields", Collections.emptyList());
            List values = this.filterAndTxFields(rawFields, fieldsIds).stream().map(this::transformRawField).collect(Collectors.toList());
            base.put("values", values);
            return base;
        }).collect(Collectors.toList());
    }

    public List exec(String pql, List<Integer> fields, boolean loadAll) {
        List projects = this.execPQL(pql, loadAll);
        return this.transformRawProjects(projects, fields);
    }
}

