/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.cloud;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.configs.JiraIntegrationProperties;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.jira.cloud.functions.ExecJQLCloudFunc;
import com.roninpixels.dashboardhub.connectors.impl.jira.cloud.functions.GetAllChangelogEntriesCloudFunc;
import com.roninpixels.dashboardhub.connectors.impl.jira.cloud.functions.GetAllFiltersCloudFunc;
import com.roninpixels.dashboardhub.connectors.impl.jira.cloud.functions.GetJqlSuggestionsCloud;
import com.roninpixels.dashboardhub.connectors.impl.jira.cloud.functions.GetProjectCloud;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.GetBoardsSprintsFunc;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.JQLResponse;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.ServiceDeskAndQueues;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.jsonBeans.VersionBean;
import com.roninpixels.dashboardhub.connectors.interfaces.ImageProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class JiraRestCloudConnector
implements JiraConnector,
ImageProvider {
    private static final Logger log = LoggerFactory.getLogger(JiraRestCloudConnector.class);
    int MAX_PROJECTS = 1000;
    private final ServerConnector connector;
    private JiraIntegrationProperties jiraProps;

    public JiraRestCloudConnector(ServerConnector connector, JiraIntegrationProperties integrationProps) {
        this.connector = connector;
        this.jiraProps = integrationProps;
    }

    @Override
    public String getURL() {
        return this.connector.getURL();
    }

    @Override
    public boolean isValid() {
        try {
            ResponseEntity<String> response = this.me();
            return response.getStatusCode().value() < 400;
        }
        catch (Exception e) {
            log.error("Problems getting cloud info. URL base: " + this.getURL(), (Throwable)e);
            return false;
        }
    }

    @Override
    public ResponseEntity<List> getProjects(Map<String, Object> params) {
        HashMap<String, Integer> mParams = params == null ? new HashMap<String, Integer>() : new HashMap<String, Object>(params);
        mParams.putIfAbsent("startAt", 0);
        mParams.putIfAbsent("maxResults", 10);
        int maxTotalResults = (Integer)mParams.get("maxResults");
        boolean moreData = true;
        LinkedList projects = new LinkedList();
        do {
            ResponseEntity<Map> response;
            if ((response = this.connector.executeRequest("/rest/api/3/project/search", mParams, Map.class)).getStatusCode().value() >= 400) {
                return new ResponseEntity(response.getStatusCode());
            }
            Map responseData = (Map)response.getBody();
            projects.addAll((List)responseData.get("values"));
            Boolean isLast = (Boolean)responseData.get("isLast") != false || maxTotalResults <= projects.size();
            int next = (Integer)responseData.get("startAt") + (Integer)responseData.get("maxResults");
            if (isLast != Boolean.TRUE && next < this.MAX_PROJECTS) {
                mParams.put("startAt", next);
                continue;
            }
            moreData = false;
        } while (moreData);
        return new ResponseEntity(projects, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<Map> getProject(String projectIdOrKey) {
        return new GetProjectCloud(this.connector).execute(projectIdOrKey);
    }

    @Override
    public ResponseEntity<Collection<VersionBean>> getProjectVersions(Long projectId, Map<String, Object> params) {
        String path = String.format("/rest/api/3/project/%s/version", projectId);
        VersionBean[] versions = (VersionBean[])this.connector.executeRequest(path, params, VersionBean[].class).getBody();
        return new ResponseEntity(Arrays.asList(versions), HttpStatus.OK);
    }

    @Override
    public JQLResponse execJQL(String jql, List<String> fields, List<String> expand, List<String> properties, Map<String, Object> extraOpts, String userKey) {
        return new ExecJQLCloudFunc(this.connector, this.jiraProps).exec(jql, fields, expand, properties, extraOpts);
    }

    @Override
    public ResponseEntity<String> autocomplete() {
        return this.connector.executeRequest("/rest/api/3/jql/autocompletedata");
    }

    @Override
    public ResponseEntity<List> getAllFilters(Map<String, ?> params, Map<String, Object> options) {
        return new GetAllFiltersCloudFunc(this.connector).getAllFilters(params, options);
    }

    @Override
    public ResponseEntity<String> jqlProxy(String jql, List<String> fields, List<String> expand, List<String> properties, Map<String, ?> extraOpts, String userKey) {
        HashMap<String, Object> mParams = extraOpts == null ? new HashMap<String, Object>() : new HashMap(extraOpts);
        mParams.putIfAbsent("maxResults", 200);
        mParams.putIfAbsent("jql", jql);
        if (fields != null) {
            mParams.putIfAbsent("fields", fields);
        }
        if (expand != null) {
            mParams.putIfAbsent("expand", expand);
        }
        if (properties != null) {
            mParams.putIfAbsent("properties", properties);
        }
        return this.connector.executeRequest(Request.MethodType.POST, "/rest/api/3/search", mParams, String.class);
    }

    @Override
    public ResponseEntity<List> getJqlSuggestions(Map<String, ?> params) {
        return new GetJqlSuggestionsCloud(this.connector).getJqlSuggestions(params);
    }

    @Override
    public ResponseEntity<String> getProjectById(Long projectId) {
        return this.connector.executeRequest("/rest/api/3/project/" + projectId);
    }

    @Override
    public ResponseEntity<Map> getFilterById(Long filterId) {
        return this.connector.executeRequest("/rest/api/3/filter/" + filterId, Collections.emptyMap(), Map.class);
    }

    @Override
    public ResponseEntity<String> getFields() throws Exception {
        return this.connector.executeRequest("/rest/api/3/field");
    }

    @Override
    public ResponseEntity<String> getIssue(Long id) throws Exception {
        return this.connector.executeRequest(String.format("/rest/api/3/issue/%d", id));
    }

    @Override
    public Map getIssueChangelog(Long id) {
        return new GetAllChangelogEntriesCloudFunc(this.connector).getData(id);
    }

    @Override
    public ResponseEntity<String> getIssueTypes() throws Exception {
        return this.connector.executeRequest("/rest/api/3/issuetype");
    }

    @Override
    public ResponseEntity<String> getStatuses() throws Exception {
        return this.connector.executeRequest("/rest/api/3/status");
    }

    @Override
    public ResponseEntity<String> getStatusCategory() throws Exception {
        return this.connector.executeRequest("/rest/api/3/statuscategory");
    }

    @Override
    public ResponseEntity<String> getPriorities() throws Exception {
        return this.connector.executeRequest("/rest/api/2/priority");
    }

    @Override
    public ResponseEntity<List> getBoards(Map<String, ?> params) throws Exception {
        HashMap<String, Integer> mParams = params == null ? new HashMap<String, Integer>() : new HashMap(params);
        mParams.putIfAbsent("startAt", 0);
        boolean moreData = true;
        LinkedList boards = new LinkedList();
        do {
            ResponseEntity<Map> response;
            if ((response = this.connector.executeRequest("/rest/agile/1.0/board", mParams, Map.class)).getStatusCode().value() >= 400) {
                return new ResponseEntity(response.getStatusCode());
            }
            Map responseData = (Map)response.getBody();
            boards.addAll((List)responseData.get("values"));
            Boolean isLast = (Boolean)responseData.get("isLast");
            int next = (Integer)responseData.get("startAt") + (Integer)responseData.get("maxResults");
            if (isLast != Boolean.TRUE && next < 1000) {
                mParams.put("startAt", next);
                continue;
            }
            moreData = false;
        } while (moreData);
        return new ResponseEntity(boards, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<List> getBoardProjects(Long boardId) {
        String path = String.format("/rest/agile/1.0/board/%d/project", boardId);
        ResponseEntity<Map> resp = this.connector.executeRequest(path, Collections.emptyMap(), Map.class);
        Map body = (Map)resp.getBody();
        List projects = body.containsKey("values") ? (List)body.get("values") : Collections.emptyList();
        return new ResponseEntity((Object)projects, resp.getStatusCode());
    }

    @Override
    public ResponseEntity<String> getBoardConfiguration(Long boardId) throws Exception {
        return this.connector.executeRequest(String.format("/rest/agile/1.0/board/%d/configuration", boardId));
    }

    @Override
    public ResponseEntity<List> getBoardsSprints(Long boardId, Map<String, ?> params, String userKey) {
        return this.getBoardsSprints(boardId, params, userKey, null);
    }

    @Override
    public ResponseEntity<List> getBoardsSprints(Long boardId, Map<String, ?> params, String userKey, Map<String, Object> paginationOptions) {
        return new GetBoardsSprintsFunc(this.connector).execute(boardId, params, paginationOptions);
    }

    @Override
    public ResponseEntity<Map> getServiceDesk(String projectId, Map<String, ?> params) throws Exception {
        return new ServiceDeskAndQueues(this.connector).getServiceDesk(projectId, params);
    }

    @Override
    public List<Map> getAllServiceDesks(Map<String, ?> params) {
        return new ServiceDeskAndQueues(this.connector).getAllServiceDesks(params);
    }

    @Override
    public ResponseEntity<Map> getQueue(String serviceDeskId, String queueId) throws Exception {
        return new ServiceDeskAndQueues(this.connector).getQueue(serviceDeskId, queueId);
    }

    @Override
    public List<Map> getQueues(String serviceDeskId, Map<String, ?> params) throws Exception {
        return new ServiceDeskAndQueues(this.connector).getQueues(serviceDeskId, params);
    }

    @Override
    public ResponseEntity<String> me() {
        return this.connector.executeRequest("/rest/api/3/myself");
    }

    @Override
    public ResponseEntity<String> serverInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResponseEntity<String> configuration() {
        return this.connector.executeRequest("/rest/api/3/configuration");
    }

    @Override
    public ResponseEntity<InputStream> getImage(String path) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "image/*");
        headers.put("encoding", "binary");
        ResponseEntity<InputStream> response = this.connector.executeRequest(Request.MethodType.GET, path, null, headers, InputStream.class);
        return response;
    }

    @Override
    public ResponseEntity<List> getGroupUsers(String groupName, Map<String, ?> params, Map<String, Object> paginationOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResponseEntity<List> getFilteredProjects(String filter) {
        HashMap<String, Object> mParams = new HashMap<String, Object>();
        mParams.put("query", filter);
        return this.getProjects(mParams);
    }

    @Override
    public Map getSprint(String sprintId) {
        String path = String.format("/rest/agile/1.0/sprint/%s", sprintId);
        ResponseEntity<Map> response = this.connector.executeRequest(path, Collections.emptyMap(), Map.class);
        ResponseChecker.checkStatus(response);
        return (Map)response.getBody();
    }

    @Override
    public boolean isCloud() {
        return true;
    }
}

