/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.factories;

import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.DatasourceBasicAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.JiraAuthenticatorStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.connectors.factories.ConnectorFactory;
import com.roninpixels.dashboardhub.connectors.factories.JiraRestConnectorFactory;
import com.roninpixels.dashboardhub.connectors.impl.bigpicture.BigPictureConnectorServerImpl;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnectorConfiguration;
import com.roninpixels.dashboardhub.connectors.impl.jira.server.JiraRestConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.BigPictureConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.RestAuthStrategyFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.ServerConnectorFactory;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.globals.ProductHosting;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class BigPictureRestConnectorFactory
implements ConnectorFactory {
    public static final String RELATIVE_PATH_SERVER = "/rest/softwareplant-bigpicture/1.0";
    @Inject
    private ServerConnectorFactory serverConnectorFactory;
    @Inject
    private RestAuthStrategyFactory authStrategyFactory;
    @Inject
    private JiraRestConnectorFactory jiraRestConnectorFactory;
    @Inject
    private Crypto crypto;
    @Inject
    private DHObjectMapper mapper;

    RestAuthStrategy getAuthStrategy(DatasourceModel ds, DsOptionsModel options) {
        ProductHosting hosting = ProductHosting.valueOfType(ds.getType());
        if (hosting == null) {
            throw new RuntimeException("Hosting not supported by " + BigPictureRestConnectorFactory.class.getName() + ": " + ds.getType());
        }
        switch (hosting) {
            case DATACENTER: {
                return this.authStrategyFactory.getRestAuthStrategy(DatasourceBasicAuthStrategy.class, ds);
            }
        }
        return this.authStrategyFactory.getRestAuthStrategy(JiraAuthenticatorStrategy.class, ds);
    }

    ServerConnectorConfiguration getConnectorConfig(DatasourceModel ds, DsOptionsModel options) {
        ServerConnectorConfiguration config = new ServerConnectorConfiguration();
        config.setUrlBaseForAPIs(ds.getUrl() + RELATIVE_PATH_SERVER);
        return config;
    }

    @Override
    public DHConnector createConnector(DatasourceModel ds) {
        DsOptionsModel options = DatasourcesUtil.decryptOptions(this.crypto, ds.getToken());
        RestAuthStrategy strategy = this.getAuthStrategy(ds, options);
        ServerConnector connector = this.serverConnectorFactory.getServerConnector(ds, strategy, this.getConnectorConfig(ds, options));
        ServerConnector connector4Jira = this.serverConnectorFactory.getServerConnector(ds, strategy);
        JiraRestConnector jiraConnector = this.jiraRestConnectorFactory.createDefaultConnector(connector4Jira);
        BigPictureConnectorServerImpl bpConnector = new BigPictureConnectorServerImpl(connector, jiraConnector);
        this.setHeadersForBP((DatasourceBasicAuthStrategy)strategy, bpConnector);
        bpConnector.sample_test();
        return bpConnector;
    }

    public void setHeadersForBP(DatasourceBasicAuthStrategy strategy, BigPictureConnectorServerImpl bpConnector) {
        try {
            RestTemplate restTemplate = new RestTemplate();
            String url = bpConnector.getURL() + "/system/auth";
            HttpHeaders headers = strategy.createHeaders();
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class, new Object[0]);
            Map authData = this.mapper.readValue((String)response.getBody(), Map.class);
            strategy.addHeader("Authorization", authData.getOrDefault("authentication", ""));
            List cookies = response.getHeaders().get((Object)"Set-Cookie");
            strategy.addHeader("Cookie", cookies);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean match(DatasourceModel ds) {
        return ds.getProduct().equals(BigPictureConnector.PRODUCT);
    }
}

