/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.servicesImpl;

import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.roninpixels.dashboardhub.confluence.CopyPageFixer;
import com.roninpixels.dashboardhub.controllers.DashboardGadgetsController;
import com.roninpixels.dashboardhub.web.models.DashboardGadgetModel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CopyPageFixerImpl
implements CopyPageFixer {
    private static final Logger log = LoggerFactory.getLogger(CopyPageFixerImpl.class);
    @Inject
    @ComponentImport
    private PageService pageService;
    @Inject
    @ComponentImport
    private PageManager pageManager;
    @Inject
    private DashboardGadgetsController dashboardGadgetsController;

    @Override
    public DashboardGadgetModel fixCopiedMacro(String actualPageId, String gadgetPageId, String gadgetId) {
        if (!gadgetPageId.equals(actualPageId)) {
            try {
                Page page = this.pageService.getIdPageLocator(Long.parseLong(actualPageId)).getPage();
                if (!this.isHistoryPage(page)) {
                    DashboardGadgetModel sourceGadget = this.dashboardGadgetsController.getDashboardGadget(gadgetPageId, gadgetId);
                    DashboardGadgetModel clonedGadget = this.cloneGadget(sourceGadget, actualPageId);
                    DashboardGadgetModel presistedGadget = this.dashboardGadgetsController.addDashboardGadget(clonedGadget, true);
                    String newGadgetId = presistedGadget.getItemId();
                    this.updatePage(page, gadgetPageId, gadgetId, actualPageId, newGadgetId);
                    return presistedGadget;
                }
            }
            catch (Exception e) {
                log.warn("Problems while trying to fix copied macro: " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private boolean isHistoryPage(Page page) {
        return page.getOriginalVersionId() != null;
    }

    private DashboardGadgetModel cloneGadget(DashboardGadgetModel gadgetModel, String newPageId) {
        DashboardGadgetModel clonedGadget = new DashboardGadgetModel();
        clonedGadget.setContainerId(newPageId);
        clonedGadget.setItemId("0");
        clonedGadget.setConfig(gadgetModel.getConfig());
        clonedGadget.setContainerTitle(gadgetModel.getContainerTitle());
        clonedGadget.setHighPriority(gadgetModel.getHighPriority());
        clonedGadget.setKey(gadgetModel.getKey());
        clonedGadget.setLayout(gadgetModel.getLayout());
        clonedGadget.setName(gadgetModel.getName());
        clonedGadget.setOwner(gadgetModel.getOwner());
        clonedGadget.setProduct(gadgetModel.getProduct());
        clonedGadget.setSize(gadgetModel.getSize());
        clonedGadget.setTitle(gadgetModel.getTitle());
        clonedGadget.setWidget(gadgetModel.getWidget());
        return clonedGadget;
    }

    private void updatePage(Page page, String oldPageId, String oldGadgetId, String newPageId, String newGadgetId) {
        String body = page.getBodyAsString();
        Matcher matcher = Pattern.compile("<ac:structured-macro .*?</ac:structured-macro>", 0).matcher(body);
        while (matcher.find()) {
            String macro = matcher.group();
            if (!this.isDhMacro(macro) || !macro.contains(this.macroParam("gadgetId", oldGadgetId)) || !macro.contains(this.macroParam("containerId", oldPageId))) continue;
            String fixedMacro = macro.replace(this.macroParam("gadgetId", oldGadgetId), this.macroParam("gadgetId", newGadgetId)).replace(this.macroParam("containerId", oldPageId), this.macroParam("containerId", newPageId));
            body = body.replace(macro, fixedMacro);
            page.setBodyAsString(body);
            this.pageManager.saveContentEntity((ContentEntityObject)page, (SaveContext)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressNotifications(true)).build());
            break;
        }
    }

    private boolean isDhMacro(String macro) {
        int dhMacroName = macro.indexOf("ac:name=\"dashboardhubgadget\"");
        return dhMacroName > 0 && dhMacroName < macro.indexOf(62);
    }

    private String macroParam(String name, String value) {
        return "<ac:parameter ac:name=\"" + name + "\">" + value + "</ac:parameter>";
    }
}

