/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.roninpixels.dashboardhub.confluence.CopyPageFixer;
import com.roninpixels.dashboardhub.confluence.macro.ImagePlaceHolderProvider;
import com.roninpixels.dashboardhub.web.models.DashboardGadgetModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;

public class GadgetsMacro
implements Macro,
EditorImagePlaceholder {
    private static final String TEMPLATE_PATH = "/templates/dashboard-hub-gadget-macro-frame.vm";
    public static final String P_NAME_GADGET_ID = "gadgetId";
    public static final String P_NAME_CONTAINER_ID = "containerId";
    public static final String P_NAME_HEIGHT = "height";
    public static final String P_NAME_WIDTH = "width";
    private static final String DEFAULT_HEIGHT = "350";
    private static final String DEFAULT_WIDTH = "100%";
    @Inject
    @ComponentImport
    private TemplateRenderer templateRenderer;
    @Inject
    private ImagePlaceHolderProvider imageProvider;
    @Inject
    private CopyPageFixer copyPageFixer;

    private String getIframeWidth(MacroDefinition macroDefinition) {
        if (macroDefinition.getParameters().containsKey(P_NAME_WIDTH)) {
            return macroDefinition.getParameter(P_NAME_WIDTH);
        }
        return DEFAULT_WIDTH;
    }

    public String execute(Map<String, String> params, String s, ConversionContext conversionContext) throws MacroExecutionException {
        Map context = MacroUtils.defaultVelocityContext();
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        long actionPageId = ((AbstractPageAwareAction)context.get("action")).getPageId();
        DashboardGadgetModel fixedGadget = this.copyPageFixer.fixCopiedMacro(Long.toString(actionPageId), params.get(P_NAME_CONTAINER_ID), params.get(P_NAME_GADGET_ID));
        if (fixedGadget != null) {
            params.put(P_NAME_CONTAINER_ID, fixedGadget.getContainerId());
            params.put(P_NAME_GADGET_ID, fixedGadget.getItemId());
        }
        context.put(P_NAME_GADGET_ID, params.get(P_NAME_GADGET_ID));
        context.put(P_NAME_CONTAINER_ID, params.get(P_NAME_CONTAINER_ID));
        context.put(P_NAME_HEIGHT, params.getOrDefault(P_NAME_HEIGHT, DEFAULT_HEIGHT));
        context.put(P_NAME_WIDTH, params.getOrDefault(P_NAME_WIDTH, this.getIframeWidth(macroDefinition)));
        MacroId macroId = macroDefinition.getMacroIdentifier().orElse(null);
        context.put("macroId", macroId != null ? macroId.getId() : "");
        context.put("macroParams", params);
        try {
            StringWriter writer = new StringWriter();
            this.templateRenderer.render(TEMPLATE_PATH, context, (Writer)writer);
            return writer.toString();
        }
        catch (IOException e) {
            return "<div>ERROR</div";
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> map, ConversionContext conversionContext) {
        return this.imageProvider.getImagePlaceholder(map, conversionContext);
    }
}

