/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.config;

import com.roninpixels.dashboardhub.config.DHStaticResources;
import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class DHStaticResourcesImpl
implements DHStaticResources {
    @Inject
    private ApplicationPropertiesAccesor propertiesAccesor;
    private String appKey;

    @PostConstruct
    public void init() {
        this.appKey = String.format("com.roninpixels.dashboards.%s", this.propertiesAccesor.getApplicationName());
    }

    private String getContextPath() {
        String baseURL = this.propertiesAccesor.getAppProperty("baseURL", "");
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)baseURL).build();
        return uriComponents.getPath() == null ? "" : uriComponents.getPath();
    }

    @Override
    public String getAppUrlBase() {
        return String.format("%s/download/resources/%s:dh-react-app/app", this.getContextPath(), this.appKey);
    }

    @Override
    public String getAppIndexJs() {
        return String.format("%s/download/resources/%s:dh-resources-prod/index.js", this.getContextPath(), this.appKey);
    }

    @Override
    public String getAppMainJs() {
        return String.format("%s/download/resources/%s:dh-main-resources/dashboardHub.js", this.getContextPath(), this.appKey);
    }

    @Override
    public String getDevJs() {
        return String.format("%s/download/resources/%s:dh-resources-dev/dev.js", this.getContextPath(), this.appKey);
    }

    @Override
    public String getResource(String resourceName) {
        switch (resourceName) {
            case "app-index": {
                return this.getAppIndexJs();
            }
            case "app-url-base": {
                return this.getAppUrlBase();
            }
            case "app-main-js": {
                return this.getAppMainJs();
            }
            case "dev-js": {
                return this.getDevJs();
            }
        }
        return "error";
    }
}

