(function() {
    const IMAGE_WIDTH = 1056;
    const IMAGE_HEIGHT = 562;
    const MACRO_DASHBOARD_NAME = 'dashboardhub';
    const MACRO_GADGET_NAME = 'dashboardhubgadget';

    const URL_BASE = window.location.origin + AJS.contextPath();
    const dhLib = {};

    const hideEditorFrame = () => {
        dhLib.macroTarget = undefined;
        dhLib.editorFrame.remove();
    }
    const saveCurrentMacro = (params) => {
        const macroParams = dhLib.getTargetMacroParams();

        const macroRenderRequest = {
            contentId: Confluence.Editor.getContentId(),
            macro: {
                name : params.gadgetId?MACRO_GADGET_NAME:MACRO_DASHBOARD_NAME,
                params : {
                    ...macroParams,
                    ...params,
                    containerId: Confluence.Editor.getContentId(),
                },
                defaultParameterValue : "",
                body : ""
            }
        };
        return tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest);
    };

    dhLib.hideEditorFrame = hideEditorFrame;
    dhLib.getTargetMacroParams = () => dhLib.targetMacroParams;
    dhLib.saveCurrentMacro = saveCurrentMacro;
    window.dhLib = dhLib;

    const getMacroParams = (macroNode) => {
        let currentParams = {};
        if (macroNode.params) {
            currentParams = {...macroNode.params};
        } else {
        currentParams = Confluence.MacroParameterSerializer
                                .deserialize($(macroNode).attr("data-macro-parameters"));
        }
        return currentParams;
    };

    const dhEdit = function(e, macroNode) {
        const macroSettings = {
            boardId: '',
            ...getMacroParams(macroNode)
        };
        window.dhLib.targetMacroParams = macroSettings;
        const newIframe = dhSoy.macro.editBoard({settings: macroSettings});
        const editorFrame = $(`${newIframe}`);
        editorFrame.appendTo('body');
        window.dhLib.editorFrame = editorFrame;
    };

    const dhEditGadget = function(e, macroNode) {
            const macroSettings = {
                gadgetId: 0,
                containerId: Confluence.Editor.getContentId(),
                ...getMacroParams(macroNode)
            };
            window.dhLib.targetMacroParams = macroSettings;
            window.containerData = {
                containerId: macroSettings.containerId,
                itemId: macroSettings.gadgetId,
                macro: true
            };
            const newIframe = dhSoy.macro.editGadget({settings: macroSettings});
            const editorFrame = $(`${newIframe}`);
            editorFrame.appendTo('body');
            window.dhLib.editorFrame = editorFrame;
    };

    const dhEditMacro = function(macroNode) {
        const macroParams = macroNode.params || getMacroParams(macroNode);
        const macroName = macroNode.name || macroNode.getAttribute('data-macro-name');

        if (macroName === MACRO_DASHBOARD_NAME && !macroParams.boardId) {
            return dhEdit({}, macroNode);
        } else if (macroName === MACRO_GADGET_NAME) {//} && !macroParams.gadgetId) {
            return dhEditGadget({}, macroNode);
        }

        const dialog = new AJS.Dialog({
            width: 600,
            height: 280,
            id: "dashboardhub-macro-dialog",
            closeOnOutsideClick: false
        });

        // dialog content
        const macroSettings = {
            boardId: '',
            width: '100%',// IMAGE_WIDTH,
            height: IMAGE_HEIGHT,
            ...macroParams
        };

        dialog.addHeader(AJS.I18n.getText("dashboardhub.settings.dialog.title"));
        const dialogParams = {
            settings: {
                ...macroSettings,
                boardToken: encodeURIComponent(macroSettings.boardToken)
            },
            urlBase: URL_BASE
        };
        dialog.addPanel("", dhSoy.macro.editParamsForm(dialogParams), "");
        dialog.addSubmit(AJS.I18n.getText("dashboardhub.settings.save.button"), function (dialog) {
            // Reads new values and validate them
            const width = $("#dashboardhub-macro-width").attr("value");
            const height = $("#dashboardhub-macro-height").attr("value");

            if ( !width.match(/^(100%|\d*)(px)?$/) ) {
                $("#dashboardHubDialogMessageContainer")
                    .html(AJS.I18n.getText('dashboardhub.settings.board.width.badFormat'));
                return;
            } else if (!height.match(/^(\d*)(px)?$/)) {
                $("#dashboardHubDialogMessageContainer")
                    .html(AJS.I18n.getText('dashboardhub.settings.board.height.badFormat'));
                return;
            }

            if ( macroSettings.width !== width || macroSettings.height !== height ) {
                const macroRenderRequest = {
                    contentId : Confluence.Editor.getContentId(),
                    macro : {
                        name : macroName,
                        params : {
                             ...macroSettings,
                             width,
                             height
                         },
                        defaultParameterValue : "",
                        body : ""
                    }
                };

                tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest)
                    .always( () => dialog.remove() );
            } else {
                dialog.remove();
            }
        });


        dialog.addCancel(AJS.I18n.getText("dashboardhub.settings.close.button"), function (dialog) {
            dialog.remove();
        });

        dialog.popup.element.css('zIndex', 3000);
        dialog.popup.element.css('marginTop', -250);
        dialog.show();
    };


    const macroResize = function(macroNode, aspect) {
        const params = getMacroParams(macroNode);
        params.width = aspect == 100 ? aspect + '%' : (IMAGE_WIDTH * aspect / 100);
        params.height = IMAGE_HEIGHT * aspect / 100;

        const macroRenderRequest = {
                contentId : Confluence.Editor.getContentId(),
                macro : {
                    name : macroNode.getAttribute('data-macro-name'),
                    params : params,
                    defaultParameterValue : "",
                    body : ""
                }
        };

        tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest, macroNode);
    };

    setTimeout(() => {
        if (AJS.Confluence.PropertyPanel.Macro) {
            AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("dh-edit-board", dhEdit);
            AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("dh-edit-gadget", dhEditGadget);
            AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("dh-size-small", function(e, macroNode) {
                macroResize(macroNode, 25);
            });

            AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("dh-size-medium", function(e, macroNode) {
                macroResize(macroNode, 50);
            });

            AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("dh-size-large", function(e, macroNode) {
                macroResize(macroNode, 75);
            });

            AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("dh-size-full-width", function(e, macroNode) {
                macroResize(macroNode, 100);
            });
        } else {
            console.error('DH macro - registerButtonHandler function is not present');
        }
    }, 300);

    AJS.MacroBrowser.setMacroJsOverride(MACRO_DASHBOARD_NAME, {opener: dhEditMacro});
    AJS.MacroBrowser.setMacroJsOverride(MACRO_GADGET_NAME, {opener: dhEditMacro});
})();